/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsql;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.DsqlParser;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.DsqlQueryTranslator;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.internal.exception.DsqlParsingException;
import org.mule.runtime.extension.internal.expression.BinaryLogicalExpression;
import org.mule.runtime.extension.internal.expression.Expression;
import org.mule.runtime.extension.internal.expression.FieldComparison;
import org.mule.runtime.extension.internal.operator.EqualsOperator;
import org.mule.runtime.extension.internal.operator.LessOperator;
import org.mule.runtime.extension.internal.operator.Operator;
import org.mule.runtime.extension.internal.value.IntegerValue;
import org.mule.runtime.extension.internal.value.NumberValue;

public class MuleDsqlParserTestCase {
    private static final boolean PRINT_AST = false;

    @Test
    public void testEasyParse() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users where name='alejo'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"*"));
        Assert.assertThat((Object)dsqlQuery.getType().getName(), (Matcher)CoreMatchers.is((Object)"users"));
        Expression filterExpression = dsqlQuery.getFilterExpression();
        this.assertFieldComparation(filterExpression, EqualsOperator.class, "name", "alejo");
    }

    private void assertFieldComparation(Expression filterExpression, Class<? extends Operator> operatorClass, String fieldName, Object value) {
        Assert.assertThat((Object)((FieldComparison)filterExpression), (Matcher)CoreMatchers.isA(FieldComparison.class));
        FieldComparison fieldComparison = (FieldComparison)filterExpression;
        Assert.assertThat((Object)fieldComparison.getField().getName(), (Matcher)CoreMatchers.is((Object)fieldName));
        Assert.assertThat((Object)fieldComparison.getValue().getValue(), (Matcher)CoreMatchers.is((Object)value));
        Class<? extends Operator> operator = operatorClass;
        Assert.assertThat((Object)fieldComparison.getOperator(), (Matcher)CoreMatchers.isA(operator));
    }

    @Test
    public void testParse1() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT name, surname from addresses where name='alejo' and (apellido='abdala' and address='guatemala 1234') order by name limit 10 offset 200");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"surname"));
        Assert.assertThat((Object)dsqlQuery.getType().getName(), (Matcher)CoreMatchers.is((Object)"addresses"));
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"name"));
        Assert.assertThat((Object)((BinaryLogicalExpression)dsqlQuery.getFilterExpression()), (Matcher)CoreMatchers.isA(BinaryLogicalExpression.class));
        BinaryLogicalExpression andExpression = (BinaryLogicalExpression)dsqlQuery.getFilterExpression();
        this.assertFieldComparation(andExpression.getLeft(), EqualsOperator.class, "name", "alejo");
        Assert.assertThat((Object)((BinaryLogicalExpression)andExpression.getRight()), (Matcher)CoreMatchers.isA(BinaryLogicalExpression.class));
        BinaryLogicalExpression innerAnd = (BinaryLogicalExpression)andExpression.getRight();
        this.assertFieldComparation(innerAnd.getLeft(), EqualsOperator.class, "apellido", "abdala");
        this.assertFieldComparation(innerAnd.getRight(), EqualsOperator.class, "address", "guatemala 1234");
    }

    @Test
    public void whenNumberLiteralNumberDoesNotContainsFloatingPointItShouldBeSetAsLong() {
        DsqlQuery parse = this.parse("dsql:SELECT name from account where age > 20");
        Expression filterExpression = parse.getFilterExpression();
        Assert.assertThat((Object)filterExpression, (Matcher)CoreMatchers.instanceOf(FieldComparison.class));
        Assert.assertThat((Object)((FieldComparison)filterExpression).getValue(), (Matcher)CoreMatchers.instanceOf(IntegerValue.class));
    }

    @Test
    public void whenNumberLiteralNumberContainsFloatingPointItShouldBeSetAsDouble() {
        DsqlQuery parse = this.parse("dsql:SELECT name from account where age > 20.3");
        Expression filterExpression = parse.getFilterExpression();
        Assert.assertThat((Object)filterExpression, (Matcher)CoreMatchers.instanceOf(FieldComparison.class));
        Assert.assertThat((Object)((FieldComparison)filterExpression).getValue(), (Matcher)CoreMatchers.instanceOf(NumberValue.class));
    }

    @Test
    public void testParse1b() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT name, surname from users, addresses where (name='alejo' and apellido='abdala') and address='guatemala 1234' order by name desc limit 10 offset 200");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testParse2() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' and apellido='abdala' or apellido='achaval' and name='mariano' and cp='1234'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParse3() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' and not (age > 25)");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testLike() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name like '%alejo%'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testExpression() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT AccountNumber,AccountSource,Active__c FROM Account WHERE AccountNumber = '#[flowVars[\\'name\\']]'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testParse4() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' and age <> 25");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParse5() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' and (age >= 25 or age <= 40)");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParse6() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT AccountSource,AnnualRevenue FROM Account WHERE ((AnnualRevenue > 22222 AND BillingCity > 123) AND AnnualRevenue >= 222222) ORDER BY Active__c LIMIT 112 OFFSET 222");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testParseAscending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' order by name ascending");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParseAscending2() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' order by name asc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParseDescending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' order by name descending");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testParseDescending2() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='alejo' order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='#[payload.name]' order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression2() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='#[payload.get(\\'id\\')]' order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithEscapedIdentifiers() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT [select], [desc] from [from] where [where] = 2 order by [asc] asc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testWithMuleExpression3() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='#[flowVars[\"id\"]]' order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression4() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where id > #[flowVars['pepe']] order by name");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression5() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where (id > #[flowVars['pepe']] and id < #[flowVars.get('id')]) order by name");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression6() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where id > #[flowVars['pepe']] and id < #[flowVars.get('id')] order by name");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression7() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where id > #[flowVars['pepe']] and id < #[[flowVars.get('[id')]] order by name");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpression9() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name='#[flowVars[\\'id\\']]' order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpressionWithDoubleQuotes() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name=\"#[flowVars['id']]\" order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWithMuleExpressionWithEscapedDoubleQuotesInString() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT * from users, addresses where name=\"#[flowVars[\\\"id\\\"]]\" order by name desc");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test(expected=DsqlParsingException.class)
    public void testFail() {
        this.parse("dsql:SELECT * from users, addresses where name='alejo' and ");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFail2() {
        this.parse("dsql:select from");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFail3() {
        this.parse("dsql:*");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFail4() {
        this.parse("dsql:SELECT *");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFail5() {
        this.parse("dsql:SELECT * from users, addresses where ");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailSelect() {
        this.parse("dsql:selecct users, addresses from Account where name = 123");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailFrom() {
        this.parse("dsql:SELECT users, addresses frrom Account where name = 123");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailFrom2() {
        this.parse("dsql:SELECT users, addresses *");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailFrom3() {
        this.parse("dsql:SELECT users, addresses ffrom");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailMissingFrom() {
        this.parse("dsql:SELECT users, addresses where");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailWhere2() {
        this.parse("dsql:SELECT users, addresses from Account where *");
    }

    @Test(expected=DsqlParsingException.class)
    public void testWithMuleExpressionShouldFail() {
        this.parse("dsql:SELECT * from users, addresses where name='#[flowVars['id']]' order by name desc");
    }

    @Test(expected=DsqlParsingException.class)
    public void testFailWhere() {
        this.parse("dsql:SELECT users, addresses from Account whseree name = 123");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailNoPrefix() {
        this.parse("SELECT users, addresses from Account whseree name = 123");
    }

    @Test
    public void testFieldsWithSpaces() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT 'Field with spaces' from Account");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field with spaces"));
    }

    @Test
    public void testNormalFieldsMixedWithFieldsWithSpaces() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField,'Field with spaces',Underscored_Field from Account");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Field with spaces"));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(2)).getName(), (Matcher)CoreMatchers.is((Object)"Underscored_Field"));
    }

    @Test
    public void testNormalFieldWithQuotes() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT 'NormalField' from Account");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
    }

    @Test
    public void testNormalFieldWithQuotesMixedWithFieldsWithSpaces() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT 'NormalField','Field With Spaces' from Account");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
    }

    @Test
    public void testTypeWithSpacesInFrom() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from 'Account Reps'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)dsqlQuery.getType().getName(), (Matcher)CoreMatchers.is((Object)"Account Reps"));
    }

    @Test
    public void testTypeWithSpacesMixedWithNormalInFrom() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from NormalType");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)dsqlQuery.getType().getName(), (Matcher)CoreMatchers.is((Object)"NormalType"));
    }

    @Test
    public void testNormalTypeWithQuotes() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from 'NormalType'");
        Assert.assertThat((Object)dsqlQuery.getFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)dsqlQuery.getType().getName(), (Matcher)CoreMatchers.is((Object)"NormalType"));
    }

    @Test
    public void testTypeWithSpacesInOrderBy() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces'");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
    }

    @Test
    public void testTypeWithSpacesMixedWithNormalInOrderBy() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces',NormalField");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
    }

    @Test
    public void testTypeWithSpacesInOrderByAscending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces' asc");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
        Assert.assertThat((Object)dsqlQuery.getDirection(), (Matcher)CoreMatchers.is((Object)Direction.ASC));
    }

    @Test
    public void testTypeWithSpacesMixedWithNormalInOrderByAscending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces',NormalField ascending");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)dsqlQuery.getDirection(), (Matcher)CoreMatchers.is((Object)Direction.ASC));
    }

    @Test
    public void testTypeWithSpacesInOrderByDescending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces' desc");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
        Assert.assertThat((Object)dsqlQuery.getDirection(), (Matcher)CoreMatchers.is((Object)Direction.DESC));
    }

    @Test
    public void testTypeWithSpacesMixedWithNormalInOrderByDescending() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account ORDER BY 'Field With Spaces',NormalField descending");
        Assert.assertThat((Object)dsqlQuery.getOrderByFields().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Field With Spaces"));
        Assert.assertThat((Object)((Field)dsqlQuery.getOrderByFields().get(1)).getName(), (Matcher)CoreMatchers.is((Object)"NormalField"));
        Assert.assertThat((Object)dsqlQuery.getDirection(), (Matcher)CoreMatchers.is((Object)Direction.DESC));
    }

    @Test
    public void testTypeWithSpacesInFilters() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account WHERE 'Field With Spaces' = 1");
        this.assertFieldComparation(dsqlQuery.getFilterExpression(), EqualsOperator.class, "Field With Spaces", 1);
    }

    @Test
    public void testFieldWithSpacesInFiltersWithParenthesis() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account WHERE ('Field With Spaces' = 1)");
        this.assertFieldComparation(dsqlQuery.getFilterExpression(), EqualsOperator.class, "Field With Spaces", 1);
    }

    @Test
    public void testFieldWithSpacesInComparison() {
        DsqlQuery dsqlQuery = this.parse("dsql:SELECT NormalField from Account WHERE ('Field With Spaces' < 1)");
        this.assertFieldComparation(dsqlQuery.getFilterExpression(), LessOperator.class, "Field With Spaces", 1);
    }

    public DsqlQuery parse(String string) {
        DsqlParser parser = DsqlParser.getInstance();
        DsqlQueryTranslator visitor = new DsqlQueryTranslator();
        DsqlQuery parse = parser.parse(string);
        parse.translate((QueryTranslator)visitor);
        return parse;
    }

    private void printTree(CommonTree tree) {
        this.printTree(tree, 0);
    }

    private void printTree(CommonTree tree, int level) {
        List children = tree.getChildren();
        System.out.println(tree.getText() + " - Type=" + tree.getType());
        if (children != null) {
            level += 2;
            for (CommonTree t : children) {
                if (t == null) continue;
                this.printLevel(level);
                this.printTree(t, level);
            }
        }
    }

    private void printLevel(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("-");
        }
        System.out.print("-> ");
    }
}

