/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import java.util.Iterator;
import java.util.List;
import org.mule.runtime.extension.api.dsql.DefaultOperatorTranslator;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.OperatorTranslator;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;

public class DsqlQueryTranslator
implements QueryTranslator {
    private final StringBuilder queryBuilder = new StringBuilder();

    DsqlQueryTranslator() {
    }

    public void translateFields(List<Field> fields) {
        StringBuilder select = new StringBuilder();
        select.append("SELECT ");
        Iterator<Field> fieldIterable = fields.iterator();
        while (fieldIterable.hasNext()) {
            String fieldName = this.addQuotesIfNeeded(fieldIterable.next().getName());
            select.append(fieldName);
            if (!fieldIterable.hasNext()) continue;
            select.append(",");
        }
        this.queryBuilder.insert(0, select);
    }

    public void translateTypes(EntityType type) {
        this.queryBuilder.append(" FROM ");
        String typeName = this.addQuotesIfNeeded(type.getName());
        this.queryBuilder.append(typeName);
    }

    public void translateOrderByFields(List<Field> orderByFields, Direction direction) {
        this.queryBuilder.append(" ORDER BY ");
        Iterator<Field> orderByFieldsIterator = orderByFields.iterator();
        while (orderByFieldsIterator.hasNext()) {
            String fieldName = this.addQuotesIfNeeded(orderByFieldsIterator.next().getName());
            this.queryBuilder.append(fieldName);
            if (!orderByFieldsIterator.hasNext()) continue;
            this.queryBuilder.append(",");
        }
        this.queryBuilder.append(" ");
        this.queryBuilder.append(direction.toString());
    }

    public void translateBeginExpression() {
        this.queryBuilder.append(" WHERE ");
    }

    public void translateInitPrecedence() {
        this.queryBuilder.append("(");
    }

    public void translateEndPrecedence() {
        this.queryBuilder.append(")");
    }

    public void translateLimit(int limit) {
        this.queryBuilder.append(" LIMIT ").append(limit);
    }

    public void translateOffset(int offset) {
        this.queryBuilder.append(" OFFSET ").append(offset);
    }

    public void translateAnd() {
        this.queryBuilder.append(" AND ");
    }

    public void translateOR() {
        this.queryBuilder.append(" OR ");
    }

    public void translateComparison(String operator, Field field, Value<?> value) {
        String name = this.addQuotesIfNeeded(field.getName());
        this.queryBuilder.append(name).append(operator).append(value.toString());
    }

    public OperatorTranslator operatorTranslator() {
        return new DefaultOperatorTranslator();
    }

    public String getTranslation() {
        return this.queryBuilder.toString();
    }

    private String addQuotesIfNeeded(String name) {
        return name.contains(" ") ? "'" + name + "'" : name;
    }
}

