/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.skyscreamer.jsonassert.JSONAssert;

public class LoadAndSerializeXmlExtensionModelsTestCase {
    public static final String SCHEMAS_GET_JOB_JSON = "schemas/greenhouse-get-job.json";
    public static final String XML_BASED_EXT_MODEL_JSON = "extension/xml-based-ext-model.json";
    protected final String LOADED_PARAMETER_NAME = "loaded";
    protected final String GET_CAR_OPERATION_NAME = "getCar";
    protected final DisplayModel defaultDisplayModel = DisplayModel.builder().build();
    protected final LayoutModel defaultLayoutModel = LayoutModel.builder().build();
    protected final ParameterDslConfiguration defaultParameterDsl = ParameterDslConfiguration.getDefaultInstance();
    protected final ClassTypeLoader typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader();
    protected final MetadataType stringType = this.typeLoader.load(String.class);
    protected ExtensionModel originalExtensionModel;
    protected JsonElement serializedExtensionModel;
    protected ExtensionModelJsonSerializer extensionModelJsonSerializer;

    @Before
    public void setup() throws IOException {
        String schema = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(SCHEMAS_GET_JOB_JSON));
        MetadataType jsonLoadedType = (MetadataType)new JsonTypeLoader(schema).load("").get();
        ImmutableParameterModel loadedParameter = new ImmutableParameterModel("loaded", "loaded type from json to serialize", jsonLoadedType, false, true, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, null, Collections.emptyList(), Collections.emptySet());
        ImmutableOutputModel outputModel = new ImmutableOutputModel("Message.Payload", this.stringType, true, Collections.emptySet());
        ImmutableOutputModel outputAttributesModel = new ImmutableOutputModel("Message.Attributes", this.stringType, false, Collections.emptySet());
        ImmutableOperationModel getCarOperation = new ImmutableOperationModel("getCar", "Obtains a car", this.asParameterGroup(new ParameterModel[]{loadedParameter}), Collections.emptyList(), (OutputModel)outputModel, (OutputModel)outputAttributesModel, true, ExecutionType.CPU_LITE, false, false, false, this.defaultDisplayModel, Collections.emptySet(), MuleStereotypes.PROCESSOR, Collections.emptySet(), Collections.emptySet());
        this.originalExtensionModel = new ImmutableExtensionModel("DummyExtension", "Test extension", "4.0.0", "MuleSoft", Category.COMMUNITY, Collections.emptyList(), Collections.singletonList(getCarOperation), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.defaultDisplayModel, XmlDslModel.builder().build(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        this.extensionModelJsonSerializer = new ExtensionModelJsonSerializer(true);
    }

    @Test
    public void serializeDeserializeExternalModel() throws IOException {
        String external = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(XML_BASED_EXT_MODEL_JSON));
        ExtensionModel externalModel = this.extensionModelJsonSerializer.deserialize(external);
        String serializedResult = this.extensionModelJsonSerializer.serialize(externalModel);
        JSONAssert.assertEquals((String)external, (String)serializedResult, (boolean)true);
    }

    @Test
    public void serializeDeserializeMock() throws IOException {
        String serializedExtensionModelString = this.extensionModelJsonSerializer.serialize(this.originalExtensionModel);
        this.serializedExtensionModel = new JsonParser().parse(serializedExtensionModelString);
        ExtensionModel deserializedExtensionModel = this.extensionModelJsonSerializer.deserialize(serializedExtensionModelString);
        MatcherAssert.assertThat((Object)this.originalExtensionModel, (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)deserializedExtensionModel)));
    }

    private List<ParameterGroupModel> asParameterGroup(ParameterModel ... parameters) {
        Set exclusiveParamNames = Stream.of(parameters).filter(p -> !p.isRequired()).map(NamedObject::getName).collect(Collectors.toSet());
        return Arrays.asList(new ImmutableParameterGroupModel("General", "", Arrays.asList(parameters), Arrays.asList(new ImmutableExclusiveParametersModel(exclusiveParamNames, false)), false, null, null, Collections.emptySet()));
    }
}

