/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.AbstractMetadataPersistenceTestCase;
import org.mule.runtime.extension.api.persistence.metadata.ComponentResultJsonSerializer;

public class SourceMetadataResultPersistenceTestCase
extends AbstractMetadataPersistenceTestCase {
    private static final String METADATA_SOURCE_RESULT_JSON = "metadata/success-result-source-descriptor.json";
    private ComponentMetadataDescriptor<SourceModel> sourceMetadataDescriptor;
    private ComponentResultJsonSerializer<SourceModel> metadataDescriptorSerializer = new ComponentResultJsonSerializer(true);

    @Override
    @Before
    public void setUp() throws IOException {
        super.setUp();
        this.sourceMetadataDescriptor = this.buildTestSourceMetadataDescriptor();
    }

    @Test
    public void serializeSuccessMetadataDescriptorResult() throws IOException {
        MetadataResult success = MetadataResult.success(this.sourceMetadataDescriptor);
        String serialized = this.metadataDescriptorSerializer.serialize(success);
        this.assertSerializedJson(serialized, METADATA_SOURCE_RESULT_JSON);
    }

    @Test
    public void deserializeSourceMetadataDescriptorResult() throws IOException {
        String resource = this.getResourceAsString(METADATA_SOURCE_RESULT_JSON);
        MetadataResult metadataResult = this.metadataDescriptorSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ComponentMetadataDescriptor)metadataResult.get()).getModel(), (Matcher)CoreMatchers.is((Object)this.sourceModel));
        this.assertMetadataAttributes(((ComponentMetadataDescriptor)metadataResult.get()).getMetadataAttributes(), this.attributes);
    }

    private ComponentMetadataDescriptor<SourceModel> buildTestSourceMetadataDescriptor() {
        return ComponentMetadataDescriptor.builder((ComponentModel)this.sourceModel).withAttributes(this.attributes).build();
    }
}

