/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelPropertyMapTypeAdapter
extends TypeAdapter<Map<Class<? extends ModelProperty>, ModelProperty>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelPropertyMapTypeAdapter.class);
    private static final Map<Class<? extends ModelProperty>, String> classNameMapping = new HashMap<Class<? extends ModelProperty>, String>();
    private static final Map<String, Class<? extends ModelProperty>> nameClassMapping;
    private final Gson gson;

    ModelPropertyMapTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, Map<Class<? extends ModelProperty>, ModelProperty> modelPropertyMap) throws IOException {
        out.beginObject();
        for (Map.Entry<Class<? extends ModelProperty>, ModelProperty> entry : modelPropertyMap.entrySet()) {
            ModelProperty modelProperty = entry.getValue();
            Class<? extends ModelProperty> modelPropertyClass = entry.getKey();
            if (!modelProperty.isPublic()) continue;
            out.name(this.getSerializableModelPropertyName(modelPropertyClass));
            TypeAdapter adapter = this.gson.getAdapter(modelPropertyClass);
            adapter.write(out, (Object)modelProperty);
        }
        out.endObject();
    }

    public Map<Class<? extends ModelProperty>, ModelProperty> read(JsonReader in) throws IOException {
        LinkedHashMap<Class<? extends ModelProperty>, ModelProperty> modelPropertyHashMap = new LinkedHashMap<Class<? extends ModelProperty>, ModelProperty>();
        in.beginObject();
        while (in.hasNext()) {
            Optional<Class<? extends ModelProperty>> typeOptional = this.getClassForModelProperty(in.nextName());
            if (typeOptional.isPresent()) {
                Class<? extends ModelProperty> type = typeOptional.get();
                TypeAdapter adapter = this.gson.getAdapter(type);
                ModelProperty read = (ModelProperty)adapter.read(in);
                modelPropertyHashMap.put(type, read);
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return modelPropertyHashMap;
    }

    private Optional<Class<? extends ModelProperty>> getClassForModelProperty(String modelPropertyName) {
        Class<? extends ModelProperty> modelPropertyClass = null;
        if (nameClassMapping.containsKey(modelPropertyName)) {
            modelPropertyClass = nameClassMapping.get(modelPropertyName);
        } else {
            try {
                modelPropertyClass = ClassUtils.getClass((String)modelPropertyName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(String.format("Error loading [%s] ModelProperty. Class not found in the current classloader", modelPropertyName));
            }
        }
        return Optional.ofNullable(modelPropertyClass);
    }

    private String getSerializableModelPropertyName(Class<?> modelPropertyClass) {
        return classNameMapping.getOrDefault(modelPropertyClass, modelPropertyClass.getName());
    }

    static {
        classNameMapping.put(OAuthModelProperty.class, "OAuth");
        classNameMapping.put(MetadataKeyIdModelProperty.class, "metadataKeyId");
        nameClassMapping = new HashMap<String, Class<? extends ModelProperty>>();
        nameClassMapping.put("OAuth", OAuthModelProperty.class);
        nameClassMapping.put("metadataKeyId", MetadataKeyIdModelProperty.class);
    }
}

