/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel;
import org.mule.runtime.extension.api.persistence.value.ValueResultJsonSerializer;
import org.mule.runtime.extension.api.values.ImmutableValue;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.internal.persistence.DefaultImplementationTypeAdapterFactory;

public class ValuesPersistenceTestCase {
    private static final ValueResult FAILURE_VALUE_RESULT = ValueResult.resultFrom((ResolvingFailure)ResolvingFailure.Builder.newFailure().withFailureCode("FAILURE_CODE").build());
    private static final Value MULTI_LEVEL_VALUE = ValueBuilder.newValue((String)"root").withChild(ValueBuilder.newValue((String)"level1").withChild(ValueBuilder.newValue((String)"level2"))).build();
    private static final ValueProviderModel VALUE_PROVIDER_MODEL = new ValueProviderModel(Arrays.asList(ValuesPersistenceTestCase.buildActingParameterModel("param1", true), ValuesPersistenceTestCase.buildActingParameterModel("param2", true), ValuesPersistenceTestCase.buildActingParameterModel("param3", false)), false, false, false, Integer.valueOf(1), "Category 1", "Id 1");
    private static final ValueResult MULTI_LEVEL_VALUE_RESULT = ValueResult.resultFrom(Collections.singleton(MULTI_LEVEL_VALUE));
    private final JsonParser jsonParser = new JsonParser();
    private final ValueResultJsonSerializer valueResultJsonSerializer = new ValueResultJsonSerializer();
    private final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DefaultImplementationTypeAdapterFactory(Value.class, ImmutableValue.class)).registerTypeAdapterFactory((TypeAdapterFactory)new DefaultImplementationTypeAdapterFactory(ActingParameterModel.class, ImmutableActingParameterModel.class)).create();

    @Test
    public void serializePartModelProperty() throws IOException {
        JsonElement serialized = this.gson.toJsonTree((Object)VALUE_PROVIDER_MODEL);
        JsonElement expected = this.loadAsJson("/values/values-provider-model.json");
        MatcherAssert.assertThat((Object)serialized, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void deserializedPartModelProperty() throws IOException {
        ValueProviderModel valueProviderModel = (ValueProviderModel)this.gson.fromJson(this.loadAsJson("/values/values-provider-model.json"), ValueProviderModel.class);
        MatcherAssert.assertThat((Object)valueProviderModel, (Matcher)CoreMatchers.is((Object)VALUE_PROVIDER_MODEL));
    }

    @Test
    public void serializeValuesResult() throws IOException {
        JsonElement serialized = this.gson.toJsonTree((Object)MULTI_LEVEL_VALUE);
        JsonElement expected = this.loadAsJson("/values/values.json");
        MatcherAssert.assertThat((Object)serialized, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void deserializeValuesResult() throws IOException {
        Value values = (Value)this.gson.fromJson(this.loadAsJson("/values/values.json"), new TypeToken<Value>(){}.getType());
        MatcherAssert.assertThat((Object)MULTI_LEVEL_VALUE, (Matcher)CoreMatchers.is((Object)values));
    }

    @Test
    public void deserializeMultiLevelValueResult() throws IOException {
        ValueResult deserialize = this.valueResultJsonSerializer.deserialize(this.loadAsString("/values/multi-level-value-result.json"));
        MatcherAssert.assertThat((Object)deserialize, (Matcher)CoreMatchers.is((Object)MULTI_LEVEL_VALUE_RESULT));
    }

    @Test
    public void serializeMultiLevelValueResult() throws IOException {
        String serialize = this.valueResultJsonSerializer.serialize(MULTI_LEVEL_VALUE_RESULT);
        MatcherAssert.assertThat((Object)this.jsonParser.parse(serialize), (Matcher)CoreMatchers.is((Object)this.loadAsJson("/values/multi-level-value-result.json")));
    }

    @Test
    public void serializeFailureValueResult() throws IOException {
        String serialize = this.valueResultJsonSerializer.serialize(FAILURE_VALUE_RESULT);
        MatcherAssert.assertThat((Object)this.jsonParser.parse(serialize), (Matcher)CoreMatchers.is((Object)this.loadAsJson("/values/failure-value-result.json")));
    }

    @Test
    public void deserializeFailureValueResult() throws IOException {
        ValueResult deserialize = this.valueResultJsonSerializer.deserialize(this.loadAsString("/values/failure-value-result.json"));
        MatcherAssert.assertThat((Object)deserialize, (Matcher)CoreMatchers.is((Object)FAILURE_VALUE_RESULT));
    }

    private JsonElement loadAsJson(String name) throws IOException {
        return this.jsonParser.parse(this.loadAsString(name));
    }

    private String loadAsString(String name) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(name));
    }

    private static ActingParameterModel buildActingParameterModel(String name, boolean required) {
        return new ImmutableActingParameterModel(name, required);
    }
}

