/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.test.meta.model.tck.TestCoreExtensionDeclarer;
import org.mule.runtime.api.test.meta.model.tck.TestWebServiceConsumerDeclarer;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.deprecated.ImmutableDeprecationModel;
import org.mule.runtime.extension.api.model.function.ImmutableFunctionModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.test.dsl.model.ComplexFieldsType;
import org.skyscreamer.jsonassert.JSONAssert;

abstract class BasePersistenceTestCase {
    protected static final String SERIALIZED_EXTENSION_MODEL_COMPATIBILITY_JSON = "/extension/serialized-extension-model-compatibility.json";
    protected static final String SERIALIZED_EXTENSION_MODEL_JSON = "/extension/serialized-extension-model.json";
    protected static final String SERIALIZED_EXTENSION_MODEL_JSON_NO_CATALOG = "/extension/serialized-extension-model-no-catalog.json";
    protected static final String LIST_OF_SERIALIZED_EXTENSION_MODEL_JSON = "/extension/list-of-serialized-extension-model.json";
    protected static final ErrorModel ANY_ERROR_MODEL = ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build();
    protected static final ErrorModel CONNECTIVITY_ERROR_MODEL = ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)"MULE").withParent(ANY_ERROR_MODEL).build();
    protected static final ErrorModel PARENT_ERROR_MODEL = ErrorModelBuilder.newError((String)"PARENT_ERROR_MODEL", (String)"ERROR_NAMESPACE").withParent(CONNECTIVITY_ERROR_MODEL).build();
    protected static final ErrorModel ERROR_MODEL = ErrorModelBuilder.newError((String)"SOME_ERROR", (String)"ERROR_NAMESPACE").withParent(PARENT_ERROR_MODEL).build();
    public static final String CREATE_CUSTOMER_REQUEST_TYPE_SCHEMA_JSON = "/schemas/create-customer-request-type-schema.json";
    public static final String TEST_PACKAGE_EXPORTED_CLASS = "test.package.ExportedClass";
    private static final String FUNCTION_NAME = "myFunction";
    private static final MuleVersion OPERATION_MIN_MULE_VERSION = new MuleVersion("4.4.0");
    private static final MuleVersion CONNECTION_PROVIDER_MIN_MULE_VERSION = new MuleVersion("4.3.0");
    private static final MuleVersion PARAMETER_MIN_MULE_VERSION = new MuleVersion("4.4.0");
    private static final MuleVersion SOURCE_MIN_MULE_VERSION = new MuleVersion("4.2.2");
    private static final MuleVersion EXTENSION_MIN_MULE_VERSION = new MuleVersion("4.2.0");
    protected final DisplayModel defaultDisplayModel = DisplayModel.builder().build();
    protected final ClassTypeLoader typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader();
    protected final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    protected final MetadataType stringType = this.typeLoader.load(String.class);
    protected final String GET_CAR_OPERATION_NAME = "getCar";
    protected final String CAR_NAME_PARAMETER_NAME = "carName";
    protected final String MODEL_PROPERTIES_NODE = "modelProperties";
    protected final String OPERATIONS_NODE = "operations";
    protected final String COMPLEX_PARAMETER_NAME = "complex";
    protected final String LOADED_PARAMETER_NAME = "loaded";
    protected static final String NO_ID_PARAMETER_NAME = "noID";
    protected final String OBJECT_MAP_NAME = "map";
    protected final String SOURCE_NAME = "Source";
    protected final ParameterDslConfiguration defaultParameterDsl = ParameterDslConfiguration.getDefaultInstance();
    protected final LayoutModel defaultLayoutModel = LayoutModel.builder().build();
    protected final ValueProviderModel defaultValueProviderModel = new ValueProviderModel(Collections.emptyList(), false, false, false, Integer.valueOf(1), "ACategory", "AId");
    protected final SampleDataProviderModel defaultSampleDataProviderModel = new SampleDataProviderModel(Collections.emptyList(), "exampleSampleData", true, true);
    protected final NonExternalizableModelProperty nonExternalizableModelProperty = new NonExternalizableModelProperty();
    protected final ExternalizableModelProperty externalizableModelProperty = new ExternalizableModelProperty();
    protected final Set<ModelProperty> modelProperties = new HashSet<ModelProperty>(Arrays.asList(this.nonExternalizableModelProperty, this.externalizableModelProperty));
    protected ExtensionModel deserializedExtensionModel;
    protected ExtensionModel originalExtensionModel;
    protected ExtensionModel compatibilityExtensionModel;
    protected OperationModel getCarOperation;
    protected ConstructModel compatibilityForeachScope;
    protected ConstructModel compatibilityChoiceRouter;
    protected OperationModel foreachScope;
    protected OperationModel choiceRouter;
    protected SourceModel sourceModel;
    protected JsonElement serializedExtensionModel;
    protected JsonObject operationModelProperties;
    protected List<ExtensionModel> extensionModelList;
    protected ExtensionModelJsonSerializer extensionModelJsonSerializer;
    protected ObjectType exportedType;
    protected OAuthModelProperty accessCodeModelProperty;
    protected AuthorizationCodeGrantType authorizationCodeGrantType;
    private FunctionModel functionModel;

    BasePersistenceTestCase() {
    }

    @Before
    public void setUp() throws IOException {
        ImmutableParameterModel carNameParameter = new ImmutableParameterModel("carName", "Name of the car", this.stringType, true, false, false, false, ExpressionSupport.SUPPORTED, (Object)"", ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), (DeprecationModel)new ImmutableDeprecationModel("This is deprecated", "1.3.0", null), Collections.emptySet(), Collections.emptyList(), PARAMETER_MIN_MULE_VERSION);
        ImmutableParameterModel usernameParameter = new ImmutableParameterModel("username", "Username", this.stringType, true, true, false, false, ExpressionSupport.SUPPORTED, (Object)"", ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), null, (Set)ImmutableSet.of((Object)"username"), Collections.emptyList());
        ImmutableParameterModel passwordParameter = new ImmutableParameterModel("password", "Password", this.stringType, false, true, false, false, ExpressionSupport.SUPPORTED, (Object)"", ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), (DeprecationModel)new ImmutableDeprecationModel("This parameter is deprecated", "1.5.0", null));
        ImmutableParameterModel complexParameter = new ImmutableParameterModel("complex", "complex type to serialize", ExtensionsTypeLoaderFactory.getDefault().createTypeLoader().load(ComplexFieldsType.class), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.singletonList(StereotypeModelBuilder.newStereotype((String)"config", (String)"test").withParent(MuleStereotypes.CONFIG).build()), Collections.emptySet(), null);
        String schema = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(CREATE_CUSTOMER_REQUEST_TYPE_SCHEMA_JSON));
        MetadataType jsonLoadedType = (MetadataType)new JsonTypeLoader(schema).load("").get();
        ImmutableParameterModel loadedParameter = new ImmutableParameterModel("loaded", "loaded type from json to serialize", jsonLoadedType, false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), null);
        this.exportedType = this.typeBuilder.objectType().id(TEST_PACKAGE_EXPORTED_CLASS).with((TypeAnnotation)new ClassInformationAnnotation(ExportedClass.class, Collections.emptyList())).with((TypeAnnotation)new TypeAliasAnnotation(ExportedClass.class.getSimpleName())).build();
        ImmutableParameterModel objectMap = new ImmutableParameterModel("map", "object map", (MetadataType)this.typeBuilder.objectType().openWith((MetadataType)this.exportedType).build(), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), null);
        ObjectTypeBuilder typeNoId = this.typeBuilder.objectType();
        typeNoId.addField().key("fieldName").value((MetadataType)this.exportedType).build();
        ImmutableParameterModel noIdParameter = new ImmutableParameterModel(NO_ID_PARAMETER_NAME, "type to serialize without ID", (MetadataType)typeNoId.build(), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, this.defaultParameterDsl, this.defaultDisplayModel, this.defaultLayoutModel, this.defaultValueProviderModel, Collections.emptyList(), Collections.emptySet(), null);
        ImmutableOutputModel outputModel = new ImmutableOutputModel("Message.Payload", this.stringType, true, Collections.emptySet());
        ImmutableOutputModel outputAttributesModel = new ImmutableOutputModel("Message.Attributes", this.stringType, false, Collections.emptySet());
        this.getCarOperation = new ImmutableOperationModel("getCar", "Obtains a car", this.asParameterGroup(new ParameterModel[]{carNameParameter, complexParameter, loadedParameter}), Collections.emptyList(), (OutputModel)outputModel, (OutputModel)outputAttributesModel, true, ExecutionType.CPU_LITE, false, false, false, this.defaultDisplayModel, Collections.singleton(ERROR_MODEL), MuleStereotypes.PROCESSOR, ComponentVisibility.PUBLIC, this.modelProperties, Collections.emptySet(), (DeprecationModel)new ImmutableDeprecationModel("This operation is deprecated", "1.3.0", "2.0.0"), this.defaultSampleDataProviderModel, (Set)ImmutableSet.of((Object)"test", (Object)"car"), OPERATION_MIN_MULE_VERSION);
        this.createCoreOperations();
        ImmutableConnectionProviderModel basicAuth = new ImmutableConnectionProviderModel("BasicAuth", "Basic Auth Config", this.asParameterGroup(new ParameterModel[]{usernameParameter, passwordParameter, objectMap}), ConnectionManagementType.NONE, true, this.externalLibrarySet(), this.defaultDisplayModel, MuleStereotypes.CONNECTION, Collections.emptySet(), null, Collections.emptySet(), CONNECTION_PROVIDER_MIN_MULE_VERSION);
        this.sourceModel = new ImmutableSourceModel("Source", "A Message Source", true, false, this.asParameterGroup(new ParameterModel[]{carNameParameter, noIdParameter}), Collections.emptyList(), (OutputModel)outputModel, (OutputModel)outputAttributesModel, Optional.of(new ImmutableSourceCallbackModel("onSuccess", "", this.asParameterGroup(new ParameterModel[]{complexParameter}), DisplayModel.builder().build(), Collections.emptySet())), Optional.empty(), Optional.empty(), false, false, false, DisplayModel.builder().build(), MuleStereotypes.SOURCE, Collections.emptySet(), ComponentVisibility.PUBLIC, Collections.emptySet(), Collections.emptySet(), null, null, (Set)ImmutableSet.of((Object)"test", (Object)"source"), SOURCE_MIN_MULE_VERSION);
        this.functionModel = new ImmutableFunctionModel(FUNCTION_NAME, "An Expression Function", this.asParameterGroup(new ParameterModel[]{usernameParameter}), (OutputModel)new ImmutableOutputModel("Payload", this.stringType, false, Collections.emptySet()), DisplayModel.builder().build(), Collections.emptySet(), null);
        LinkedHashSet<ObjectType> typesCatalog = new LinkedHashSet<ObjectType>();
        typesCatalog.add(this.exportedType);
        typesCatalog.add((ObjectType)jsonLoadedType);
        this.configureOAuth();
        this.originalExtensionModel = new ImmutableExtensionModel("DummyExtension", "Test extension", "4.0.0", "MuleSoft", Category.COMMUNITY, Collections.emptyList(), Arrays.asList(this.getCarOperation, this.foreachScope, this.choiceRouter), Collections.singletonList(basicAuth), Collections.singletonList(this.sourceModel), Collections.singletonList(this.functionModel), Collections.emptyList(), this.defaultDisplayModel, XmlDslModel.builder().build(), Collections.emptySet(), typesCatalog, Collections.emptySet(), Collections.emptySet(), (Set)ImmutableSet.of((Object)ERROR_MODEL, (Object)PARENT_ERROR_MODEL, (Object)CONNECTIVITY_ERROR_MODEL, (Object)ANY_ERROR_MODEL), this.externalLibrarySet(), Collections.emptySet(), Collections.emptySet(), Collections.singleton(this.accessCodeModelProperty), Collections.emptySet(), null, null, EXTENSION_MIN_MULE_VERSION, new LinkedHashSet<String>(Arrays.asList("1.8", "11")));
        this.compatibilityExtensionModel = new ImmutableExtensionModel("DummyExtension", "Test extension", "4.0.0", "MuleSoft", Category.COMMUNITY, Collections.emptyList(), Arrays.asList(this.getCarOperation), Collections.singletonList(basicAuth), Collections.singletonList(this.sourceModel), Collections.singletonList(this.functionModel), Arrays.asList(this.compatibilityForeachScope, this.compatibilityChoiceRouter), this.defaultDisplayModel, XmlDslModel.builder().build(), Collections.emptySet(), typesCatalog, Collections.emptySet(), Collections.emptySet(), (Set)ImmutableSet.of((Object)ERROR_MODEL, (Object)PARENT_ERROR_MODEL, (Object)CONNECTIVITY_ERROR_MODEL, (Object)ANY_ERROR_MODEL), this.externalLibrarySet(), Collections.emptySet(), Collections.emptySet(), Collections.singleton(this.accessCodeModelProperty), Collections.emptySet(), null, null, EXTENSION_MIN_MULE_VERSION, new LinkedHashSet<String>(Arrays.asList("1.8", "11")));
        this.extensionModelJsonSerializer = new ExtensionModelJsonSerializer(true);
        String serializedExtensionModelString = this.extensionModelJsonSerializer.serialize(this.originalExtensionModel);
        this.serializedExtensionModel = new JsonParser().parse(serializedExtensionModelString);
        this.deserializedExtensionModel = this.extensionModelJsonSerializer.deserialize(serializedExtensionModelString);
        this.operationModelProperties = this.serializedExtensionModel.getAsJsonObject().get("operations").getAsJsonArray().get(0).getAsJsonObject().get("modelProperties").getAsJsonObject();
        this.extensionModelList = Arrays.asList(this.deserializedExtensionModel, this.originalExtensionModel);
    }

    private void configureOAuth() {
        this.authorizationCodeGrantType = new AuthorizationCodeGrantType("http://accessToken.url", "http://authorization.url", "#[accessToken]", "#[expiration]", "#[refreshToken]", "#[defaultScope]");
        this.accessCodeModelProperty = new OAuthModelProperty(Arrays.asList(this.authorizationCodeGrantType));
    }

    private void createCoreOperations() {
        ExtensionModel compatibilityCoreModel = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                new TestCoreExtensionDeclarer().compatibilityDeclareOn(context.getExtensionDeclarer());
            }
        }.loadExtensionModel(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), new HashMap());
        this.compatibilityForeachScope = (ConstructModel)compatibilityCoreModel.getConstructModel("foreach").get();
        this.compatibilityChoiceRouter = (ConstructModel)compatibilityCoreModel.getConstructModel("choice").get();
        ExtensionModel coreModel = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                new TestCoreExtensionDeclarer().declareOn(context.getExtensionDeclarer());
            }
        }.loadExtensionModel(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), new HashMap());
        this.foreachScope = (OperationModel)coreModel.getOperationModel("foreach").get();
        this.choiceRouter = (OperationModel)coreModel.getOperationModel("choice").get();
    }

    protected String getResourceAsString(String fileName) throws IOException {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        return IOUtils.toString((InputStream)resourceAsStream);
    }

    void assertSerializedJson(String serializedResult, String expectedFileName) throws IOException {
        this.assertSerializedJson(serializedResult, expectedFileName, true);
    }

    void assertSerializedJson(String serializedResult, String expectedFileName, boolean strict) throws IOException {
        String expected = this.getResourceAsString(expectedFileName);
        try {
            JSONAssert.assertEquals((String)expected, (String)serializedResult, (boolean)strict);
        }
        catch (AssertionError e) {
            System.out.println("Expected the contents of " + expectedFileName + " but got:\n" + serializedResult);
            throw e;
        }
    }

    private Set<ExternalLibraryModel> externalLibrarySet() {
        HashSet<ExternalLibraryModel> externalLibraryModels = new HashSet<ExternalLibraryModel>();
        externalLibraryModels.add(TestWebServiceConsumerDeclarer.EXTERNAL_LIBRARY_MODEL);
        return externalLibraryModels;
    }

    private List<ParameterGroupModel> asParameterGroup(ParameterModel ... parameters) {
        Set exclusiveParamNames = Stream.of(parameters).filter(p -> !p.isRequired()).map(NamedObject::getName).collect(Collectors.toSet());
        return Arrays.asList(new ImmutableParameterGroupModel("General", "", Arrays.asList(parameters), Arrays.asList(new ImmutableExclusiveParametersModel(exclusiveParamNames, false)), false, null, null, Collections.emptySet()));
    }

    public static class NonExternalizableModelProperty
    implements ModelProperty {
        public String getName() {
            return "NonExternalizableModelProperty";
        }

        public boolean isPublic() {
            return false;
        }
    }

    public static class ExternalizableModelProperty
    implements ModelProperty {
        public String getName() {
            return "ExternalizableModelProperty";
        }

        public boolean isPublic() {
            return true;
        }
    }

    public static class ExportedClass {
    }
}

