/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableActingParameterModel;
import org.mule.runtime.extension.internal.persistence.DefaultImplementationTypeAdapterFactory;

public class SampleDataPersistenceTestCase {
    private static final SampleDataProviderModel SAMPLE_DATA_PERSISTENCE_MODEL = new SampleDataProviderModel(Arrays.asList(SampleDataPersistenceTestCase.buildActingParameterModel("param1", true), SampleDataPersistenceTestCase.buildActingParameterModel("param2", true), SampleDataPersistenceTestCase.buildActingParameterModel("param3", false)), "sample data", true, true);
    private final JsonParser jsonParser = new JsonParser();
    private final Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new DefaultImplementationTypeAdapterFactory(ActingParameterModel.class, ImmutableActingParameterModel.class)).create();

    @Test
    public void serializeSampleDataProvider() throws IOException {
        JsonElement serialized = this.gson.toJsonTree((Object)SAMPLE_DATA_PERSISTENCE_MODEL);
        JsonElement expected = this.loadAsJson("/data/sample/sample-data-provider-model.json");
        MatcherAssert.assertThat((Object)serialized, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void deserializedPartModelProperty() throws IOException {
        SampleDataProviderModel model = (SampleDataProviderModel)this.gson.fromJson(this.loadAsJson("/data/sample/sample-data-provider-model.json"), SampleDataProviderModel.class);
        MatcherAssert.assertThat((Object)model, (Matcher)CoreMatchers.equalTo((Object)SAMPLE_DATA_PERSISTENCE_MODEL));
    }

    private JsonElement loadAsJson(String name) throws IOException {
        return this.jsonParser.parse(this.loadAsString(name));
    }

    private String loadAsString(String name) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(name));
    }

    private static ActingParameterModel buildActingParameterModel(String name, boolean required) {
        return new ImmutableActingParameterModel(name, required);
    }
}

