/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Optional;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.security.CredentialsPlacement;

public class OAuthGrantTypeTypeAdapter
extends TypeAdapter<OAuthGrantType> {
    private static final String GRANT_TYPE = "grantType";
    private static final String AUTH_CODE = "Authorization Code";
    private static final String CLIENT_CREDENTIALS = "Client Credentials";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String EXPIRATION_REGEX = "expirationRegex";
    private static final String DEFAULT_SCOPES = "defaultScopes";
    private static final String CREDENTIALS_PLACEMENT = "credentialsPlacement";
    private static final String ACCESS_TOKEN_EXPR = "accessTokenExpr";
    private static final String REFRESH_TOKEN_EXPR = "refreshTokenExpr";
    private static final String DEFAULT_SCOPE = "defaultScope";
    private static final String ACCESS_TOKEN_URL = "accessTokenUrl";
    private static final String AUTHORIZATION_URL = "authorizationUrl";

    public void write(final JsonWriter out, OAuthGrantType value) throws IOException {
        try {
            value.accept(new OAuthGrantTypeVisitor(){

                public void visit(AuthorizationCodeGrantType grantType) {
                    try {
                        out.beginObject();
                        out.name(OAuthGrantTypeTypeAdapter.GRANT_TYPE).value(OAuthGrantTypeTypeAdapter.AUTH_CODE);
                        out.name(OAuthGrantTypeTypeAdapter.ACCESS_TOKEN_URL).value(grantType.getAccessTokenUrl());
                        out.name(OAuthGrantTypeTypeAdapter.AUTHORIZATION_URL).value(grantType.getAuthorizationUrl());
                        out.name(OAuthGrantTypeTypeAdapter.ACCESS_TOKEN_EXPR).value(grantType.getAccessTokenExpr());
                        out.name(OAuthGrantTypeTypeAdapter.EXPIRATION_REGEX).value(grantType.getExpirationRegex());
                        out.name(OAuthGrantTypeTypeAdapter.REFRESH_TOKEN_EXPR).value(grantType.getRefreshTokenExpr());
                        OAuthGrantTypeTypeAdapter.this.writeOptional(out, OAuthGrantTypeTypeAdapter.DEFAULT_SCOPE, grantType.getDefaultScope());
                        out.endObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void visit(ClientCredentialsGrantType grantType) {
                    try {
                        out.beginObject();
                        out.name(OAuthGrantTypeTypeAdapter.GRANT_TYPE).value(OAuthGrantTypeTypeAdapter.CLIENT_CREDENTIALS);
                        out.name(OAuthGrantTypeTypeAdapter.TOKEN_URL).value(grantType.getTokenUrl());
                        out.name(OAuthGrantTypeTypeAdapter.ACCESS_TOKEN_URL).value(grantType.getAccessTokenExpr());
                        out.name(OAuthGrantTypeTypeAdapter.EXPIRATION_REGEX).value(grantType.getExpirationRegex());
                        OAuthGrantTypeTypeAdapter.this.writeOptional(out, OAuthGrantTypeTypeAdapter.DEFAULT_SCOPES, grantType.getDefaultScopes());
                        out.name(OAuthGrantTypeTypeAdapter.CREDENTIALS_PLACEMENT).value(grantType.getCredentialsPlacement().name());
                        out.endObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void visit(PlatformManagedOAuthGrantType grantType) {
                    try {
                        out.beginObject();
                        out.name(OAuthGrantTypeTypeAdapter.GRANT_TYPE).value("Platform Managed");
                        out.endObject();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public OAuthGrantType read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        String grantType = this.getOptionalValue(json, GRANT_TYPE, AUTH_CODE);
        if (AUTH_CODE.equals(grantType)) {
            return new AuthorizationCodeGrantType(json.get(ACCESS_TOKEN_URL).getAsString(), json.get(AUTHORIZATION_URL).getAsString(), json.get(ACCESS_TOKEN_EXPR).getAsString(), json.get(EXPIRATION_REGEX).getAsString(), json.get(REFRESH_TOKEN_EXPR).getAsString(), this.getOptionalValue(json, DEFAULT_SCOPE));
        }
        if (CLIENT_CREDENTIALS.equals(grantType)) {
            return new ClientCredentialsGrantType(json.get(TOKEN_URL).getAsString(), json.get(ACCESS_TOKEN_URL).getAsString(), json.get(EXPIRATION_REGEX).getAsString(), this.getOptionalValue(json, DEFAULT_SCOPES), CredentialsPlacement.valueOf((String)json.get(CREDENTIALS_PLACEMENT).getAsString()));
        }
        throw new IllegalArgumentException("Unsupported Grant Type: " + grantType);
    }

    private String getOptionalValue(JsonObject json, String property) {
        return this.getOptionalValue(json, property, "");
    }

    private String getOptionalValue(JsonObject json, String property, String defaultValue) {
        return json.has(property) ? json.get(property).getAsString() : defaultValue;
    }

    private void writeOptional(JsonWriter out, String property, Optional<String> value) throws IOException {
        if (value.isPresent()) {
            out.name(property).value(value.get());
        }
    }
}

