/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.AbstractMetadataPersistenceTestCase;
import org.mule.runtime.extension.api.persistence.metadata.ComponentResultJsonSerializer;

public class ComponentMetadataResultPersistenceTestCase
extends AbstractMetadataPersistenceTestCase {
    private static final String METADATA_RESULT_FAILURE_JSON = "metadata/failure-result.json";
    private static final String METADATA_RESULT_FAILURE_NO_DESCRIPTOR_JSON = "metadata/failure-no-descriptor-result.json";
    private static final String METADATA_WITHOUT_INPUT_FAILURE_JSON = "metadata/failure-no-dynamic-metadata-available.json";
    private static final String METADATA_RESULT_ERROR_MESSAGE = "Metadata Failure Error";
    private static final String FIRST_ERROR_MESSAGE = "FIRST_ERROR";
    private static final String SECOND_ERROR_MESSAGE = "SECOND_ERROR";
    private ComponentResultJsonSerializer<ComponentModel> metadataDescriptorSerializer = new ComponentResultJsonSerializer(true);

    @Override
    @Before
    public void setUp() throws IOException {
        super.setUp();
    }

    @Test
    public void serializeFailureMetadataResult() throws IOException {
        MetadataResult failureResult = MetadataResult.failure((Object)ComponentMetadataDescriptor.builder(null).withAttributes(this.attributes).build(), (MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(FIRST_ERROR_MESSAGE).withFailureCode(FailureCode.CONNECTION_FAILURE).withReason(METADATA_RESULT_ERROR_MESSAGE).onComponent(), MetadataFailure.Builder.newFailure().withMessage(SECOND_ERROR_MESSAGE).withFailureCode(FailureCode.INVALID_METADATA_KEY).withReason(METADATA_RESULT_ERROR_MESSAGE).onComponent()});
        String serialized = this.metadataDescriptorSerializer.serialize(failureResult);
        this.assertSerializedJson(serialized, METADATA_RESULT_FAILURE_JSON);
    }

    @Test
    public void serializeFailureMetadataResultNoDescriptor() throws IOException {
        MetadataResult failureResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(FIRST_ERROR_MESSAGE).withFailureCode(FailureCode.CONNECTION_FAILURE).withReason(METADATA_RESULT_ERROR_MESSAGE).onComponent(), MetadataFailure.Builder.newFailure().withMessage(SECOND_ERROR_MESSAGE).withFailureCode(FailureCode.INVALID_METADATA_KEY).withReason(METADATA_RESULT_ERROR_MESSAGE).onComponent()});
        String serialized = this.metadataDescriptorSerializer.serialize(failureResult);
        this.assertSerializedJson(serialized, METADATA_RESULT_FAILURE_NO_DESCRIPTOR_JSON);
    }

    @Test
    public void deserializeNoDynamicMetadataAvailable() throws IOException {
        String resource = this.getResourceAsString(METADATA_WITHOUT_INPUT_FAILURE_JSON);
        MetadataResult metadataResult = this.metadataDescriptorSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadataResult.getFailures().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        MetadataFailure metadataFailure = (MetadataFailure)metadataResult.getFailures().get(0);
        MatcherAssert.assertThat((Object)metadataFailure.getReason(), (Matcher)CoreMatchers.is((Object)METADATA_RESULT_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getMessage(), (Matcher)CoreMatchers.is((Object)METADATA_RESULT_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getFailureCode().getName(), (Matcher)CoreMatchers.is((Object)FailureCode.NO_DYNAMIC_METADATA_AVAILABLE.getName()));
    }

    @Test
    public void deserializeFailureResult() throws IOException {
        String resource = this.getResourceAsString(METADATA_RESULT_FAILURE_JSON);
        MetadataResult metadataResult = this.metadataDescriptorSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadataResult.getFailures().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        MetadataFailure metadataFailure = (MetadataFailure)metadataResult.getFailures().get(0);
        MatcherAssert.assertThat((Object)metadataFailure.getReason(), (Matcher)CoreMatchers.is((Object)METADATA_RESULT_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getMessage(), (Matcher)CoreMatchers.is((Object)FIRST_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getFailureCode().getName(), (Matcher)CoreMatchers.is((Object)FailureCode.CONNECTION_FAILURE.getName()));
        metadataFailure = (MetadataFailure)metadataResult.getFailures().get(1);
        MatcherAssert.assertThat((Object)metadataFailure.getMessage(), (Matcher)CoreMatchers.is((Object)SECOND_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getFailureCode().getName(), (Matcher)CoreMatchers.is((Object)FailureCode.INVALID_METADATA_KEY.getName()));
    }
}

