/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.text.IsEmptyString;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.extension.api.persistence.metadata.EntityMetadataResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.metadata.MetadataKeysResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.test.AbstractMetadataPersistenceTestCase;

public class MetadataKeyResultPersistenceTestCase
extends AbstractMetadataPersistenceTestCase {
    private static final String METADATA_KEYS_RESULT_JSON = "/metadata/success-result-keys.json";
    private static final String NULL_METADATA_KEYS_RESULT_JSON = "/metadata/success-result-null-keys.json";
    private static final String NULL_VALUE_METADATA_KEYS_RESULT_JSON = "/metadata/success-result-null-value-keys.json";
    private static final String METADATA_MULTILEVEL_KEYS_RESULT_JSON = "/metadata/success-result-multilevel-keys.json";
    private static final String METADATA_KEYS_RESULT_FAILURE_JSON = "/metadata/failure-keys-result.json";
    private static final String METADATA_ENTITY_RESULT_FAILURE_JSON = "/metadata/failure-entity-result.json";
    private static final String METADATA_MULTI_LEVEL_KEY_RESULT_JSON = "/metadata/multi-level-key-result.json";
    private static final String FIRST_KEY_ID = "firstKey";
    private static final String SECOND_KEY_ID = "secondKey";
    private static final String METADATA_RESULT_ERROR_MESSAGE = "Metadata Failure Error";
    private static final String FIRST_CHILD = "firstChild";
    private static final String SECOND_CHILD = "secondChild";
    private static final String THIRD_LEVEL_CHILD = "3rd Level Child";
    private final MetadataKeysResultJsonSerializer keysResultSerializer = new MetadataKeysResultJsonSerializer(true);
    private final EntityMetadataResultJsonSerializer typeDescriptorResultJsonSerializer = new EntityMetadataResultJsonSerializer(true);
    private MetadataKeysContainerBuilder builder = MetadataKeysContainerBuilder.getInstance();
    protected final MetadataKey key = MetadataKeyBuilder.newKey((String)"Key ID").withDisplayName("Key Name").build();
    protected final NamedTypeResolver resolver = (NamedTypeResolver)Mockito.mock(NamedTypeResolver.class);

    @Before
    public void setup() throws IOException {
        super.setUp();
        this.builder = MetadataKeysContainerBuilder.getInstance();
    }

    @Test
    public void multiLevelLoadAndSerialize() throws Exception {
        String keys = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(METADATA_MULTI_LEVEL_KEY_RESULT_JSON));
        this.assertLoadAndSerialize(keys);
    }

    @Test
    public void serializeSuccessMetadataKeysResult() throws IOException {
        LinkedHashSet<MetadataKey> keys = new LinkedHashSet<MetadataKey>();
        keys.add(MetadataKeyBuilder.newKey((String)FIRST_KEY_ID).build());
        keys.add(MetadataKeyBuilder.newKey((String)SECOND_KEY_ID).build());
        MetadataResult successResult = MetadataResult.success((Object)this.builder.add("categoryName", keys).build());
        String serialized = this.keysResultSerializer.serialize(successResult);
        this.assertSerializedJson(serialized, METADATA_KEYS_RESULT_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeNullPayloadMetadataKeysResult() throws IOException {
        MetadataResult failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(METADATA_RESULT_ERROR_MESSAGE).withFailureCode(FailureCode.NOT_AUTHORIZED).withReason(METADATA_RESULT_ERROR_MESSAGE).onKeys()});
        String serialized = this.keysResultSerializer.serialize(failure);
        this.assertSerializedJson(serialized, METADATA_KEYS_RESULT_FAILURE_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeSuccessNullMetadataKeysResult() throws IOException {
        LinkedHashSet<NullMetadataKey> keys = new LinkedHashSet<NullMetadataKey>();
        keys.add(new NullMetadataKey());
        MetadataResult successResult = MetadataResult.success((Object)this.builder.add("categoryName", keys).build());
        String serialized = this.keysResultSerializer.serialize(successResult);
        this.assertSerializedJson(serialized, NULL_METADATA_KEYS_RESULT_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeSuccessNullValueForMetadataKeysResult() throws IOException {
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
        keys.add(null);
        MetadataResult successResult = MetadataResult.success((Object)this.builder.add("categoryName", keys).build());
        String serialized = this.keysResultSerializer.serialize(successResult);
        this.assertSerializedJson(serialized, NULL_VALUE_METADATA_KEYS_RESULT_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeSuccessMultilevelMetadataKeyResult() throws IOException {
        LinkedHashSet<MetadataKey> keys = new LinkedHashSet<MetadataKey>();
        keys.add(MetadataKeyBuilder.newKey((String)FIRST_KEY_ID).withChild(MetadataKeyBuilder.newKey((String)FIRST_CHILD)).withChild(MetadataKeyBuilder.newKey((String)SECOND_CHILD).withChild(MetadataKeyBuilder.newKey((String)THIRD_LEVEL_CHILD))).build());
        keys.add(MetadataKeyBuilder.newKey((String)SECOND_KEY_ID).build());
        String serialized = this.keysResultSerializer.serialize(MetadataResult.success((Object)this.builder.add("categoryName", keys).build()));
        this.assertSerializedJson(serialized, METADATA_MULTILEVEL_KEYS_RESULT_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeFailureMultilevelMetadataKeyResult() throws IOException {
        MetadataResult failureResult = MetadataResult.failure((Object)this.builder.build(), (MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(METADATA_RESULT_ERROR_MESSAGE).withFailureCode(FailureCode.NOT_AUTHORIZED).withReason(METADATA_RESULT_ERROR_MESSAGE).onKeys()});
        String serialized = this.keysResultSerializer.serialize(failureResult);
        this.assertSerializedJson(serialized, METADATA_KEYS_RESULT_FAILURE_JSON);
        this.assertLoadAndSerialize(serialized);
    }

    @Test
    public void serializeFailureEntityMetadataResult() throws IOException {
        MetadataResult failureResult = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(METADATA_RESULT_ERROR_MESSAGE).withFailureCode(FailureCode.CONNECTION_FAILURE).withReason(METADATA_RESULT_ERROR_MESSAGE).onComponent()});
        String serialized = this.typeDescriptorResultJsonSerializer.serialize(failureResult);
        this.assertSerializedJson(serialized, METADATA_ENTITY_RESULT_FAILURE_JSON);
    }

    @Test
    public void deserializeMetadataKeysResult() throws IOException {
        String resource = this.getResourceAsString(METADATA_KEYS_RESULT_JSON);
        MetadataResult metadataResult = this.keysResultSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        MetadataKeysContainer container = (MetadataKeysContainer)metadataResult.get();
        MatcherAssert.assertThat((Object)container.getKeys("categoryName").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Iterator iterator = ((Set)container.getKeys("categoryName").get()).iterator();
        MatcherAssert.assertThat((Object)((MetadataKey)iterator.next()).getDisplayName(), (Matcher)CoreMatchers.is((Object)FIRST_KEY_ID));
        MatcherAssert.assertThat((Object)((MetadataKey)iterator.next()).getDisplayName(), (Matcher)CoreMatchers.is((Object)SECOND_KEY_ID));
    }

    @Test
    public void deserializeFailureKeysResult() throws IOException {
        String resource = this.getResourceAsString(METADATA_KEYS_RESULT_FAILURE_JSON);
        MetadataResult metadataResult = this.keysResultSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadataResult.getFailures().isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        MetadataFailure metadataFailure = (MetadataFailure)metadataResult.getFailures().get(0);
        MatcherAssert.assertThat((Object)metadataFailure.getReason(), (Matcher)CoreMatchers.is((Object)METADATA_RESULT_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getMessage(), (Matcher)CoreMatchers.is((Object)METADATA_RESULT_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)metadataFailure.getFailureCode().getName(), (Matcher)CoreMatchers.is((Object)FailureCode.NOT_AUTHORIZED.getName()));
    }

    @Test
    public void deserializeNullMetadataKeysResult() throws IOException {
        String resource = this.getResourceAsString(NULL_METADATA_KEYS_RESULT_JSON);
        MetadataResult metadataResult = this.keysResultSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        MetadataKeysContainer container = (MetadataKeysContainer)metadataResult.get();
        MatcherAssert.assertThat((Object)container.getKeys("categoryName").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Iterator iterator = ((Set)container.getKeys("categoryName").get()).iterator();
        MetadataKey metadataKey = (MetadataKey)iterator.next();
        MatcherAssert.assertThat((Object)metadataKey, (Matcher)CoreMatchers.instanceOf(NullMetadataKey.class));
        MatcherAssert.assertThat((Object)metadataKey.getId(), (Matcher)IsEmptyString.isEmptyString());
    }

    @Test
    public void deserializeNullValueMetadataKeysResult() throws IOException {
        String resource = this.getResourceAsString(NULL_VALUE_METADATA_KEYS_RESULT_JSON);
        MetadataResult metadataResult = this.keysResultSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        MetadataKeysContainer container = (MetadataKeysContainer)metadataResult.get();
        MatcherAssert.assertThat((Object)container.getKeys("categoryName").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Iterator iterator = ((Set)container.getKeys("categoryName").get()).iterator();
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((MetadataKey)iterator.next()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private void assertLoadAndSerialize(String json) {
        MetadataResult deserialized = this.keysResultSerializer.deserialize(json);
        String reSerialized = this.keysResultSerializer.serialize(deserialized);
        JsonParser jsonParser = new JsonParser();
        JsonElement expected = jsonParser.parse(json);
        JsonElement result = jsonParser.parse(reSerialized);
        if (!result.equals(expected)) {
            System.out.println("Expected: \n " + json);
            System.out.println("\n\nBut Got: \n " + reSerialized);
        }
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)expected));
    }
}

