/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.text.IsEqualCompressingWhiteSpace;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.ComponentMetadataTypesDescriptorResultJsonSerializer;

public class ComponentMetadataTypesDescriptorResultJsonSerializerTestCase {
    private final ComponentMetadataTypesDescriptorResultJsonSerializer serializer = new ComponentMetadataTypesDescriptorResultJsonSerializer(false, true);

    @Test
    public void failureResult() {
        String expectedError = "Expected error message";
        MetadataResult error = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)new IllegalStateException(expectedError)).onComponent()});
        MetadataResult deserialize = this.serializer.deserialize(this.serializer.serialize(error));
        Assert.assertThat((Object)deserialize.isSuccess(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)deserialize.getFailures(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        MetadataFailure failure = (MetadataFailure)deserialize.getFailures().get(0);
        Assert.assertThat((Object)failure.getMessage(), (Matcher)Matchers.is((Object)expectedError));
        Assert.assertThat((Object)failure.getFailureCode(), (Matcher)Matchers.is((Object)FailureCode.UNKNOWN));
    }

    @Test
    public void successInputMetadata() {
        DefaultStringType paramAType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().defaultValue("defaultValue").length(Integer.valueOf(1)).build();
        ArrayType paramBType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType()).build();
        InputMetadataDescriptor inputMetadataDescriptor = ((InputMetadataDescriptor.InputMetadataDescriptorBuilder)((InputMetadataDescriptor.InputMetadataDescriptorBuilder)InputMetadataDescriptor.builder().withParameter("paramA", ParameterMetadataDescriptor.builder((String)"paramA").withType((MetadataType)paramAType).dynamic(true).build())).withParameter("paramB", ParameterMetadataDescriptor.builder((String)"paramB").withType((MetadataType)paramBType).dynamic(true).build())).build();
        MetadataResult success = MetadataResult.success((Object)ComponentMetadataTypesDescriptor.builder().withInputMetadataDescriptor(inputMetadataDescriptor).build());
        MetadataResult deserialize = this.serializer.deserialize(this.serializer.serialize(success));
        Assert.assertThat((Object)deserialize.isSuccess(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)deserialize.getFailures(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        ComponentMetadataTypesDescriptor deserializedComponentMetadataTypes = (ComponentMetadataTypesDescriptor)deserialize.get();
        ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.assertMetadataTypeEquals((MetadataType)deserializedComponentMetadataTypes.getInputMetadata().get("paramA"), (MetadataType)paramAType);
        ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.assertMetadataTypeEquals((MetadataType)deserializedComponentMetadataTypes.getInputMetadata().get("paramB"), (MetadataType)paramBType);
    }

    @Test
    public void successOutput() {
        DefaultStringType outputAttributesType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().defaultValue("defaultValue").length(Integer.valueOf(1)).build();
        ArrayType outputType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType()).build();
        OutputMetadataDescriptor outputMetadataResult = OutputMetadataDescriptor.builder().withReturnType(TypeMetadataDescriptor.builder().withType((MetadataType)outputType).dynamic(true).build()).withAttributesType(TypeMetadataDescriptor.builder().withType((MetadataType)outputAttributesType).dynamic(true).build()).build();
        MetadataResult success = MetadataResult.success((Object)ComponentMetadataTypesDescriptor.builder().withOutputMetadataDescriptor(outputMetadataResult).build());
        MetadataResult deserialize = this.serializer.deserialize(this.serializer.serialize(success));
        Assert.assertThat((Object)deserialize.isSuccess(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)deserialize.getFailures(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        ComponentMetadataTypesDescriptor deserializedComponentMetadataTypes = (ComponentMetadataTypesDescriptor)deserialize.get();
        Assert.assertThat((Object)deserializedComponentMetadataTypes.getInputMetadata().isEmpty(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)deserializedComponentMetadataTypes.getOutputAttributesMetadata().isPresent(), (Matcher)Matchers.is((Object)true));
        ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.assertMetadataTypeEquals((MetadataType)deserializedComponentMetadataTypes.getOutputAttributesMetadata().get(), (MetadataType)outputAttributesType);
        Assert.assertThat((Object)deserializedComponentMetadataTypes.getOutputMetadata().isPresent(), (Matcher)Matchers.is((Object)true));
        ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.assertMetadataTypeEquals((MetadataType)deserializedComponentMetadataTypes.getOutputAttributesMetadata().get(), (MetadataType)outputAttributesType);
    }

    static void assertMetadataTypeEquals(MetadataType expected, MetadataType actual) {
        ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.assertMetadataTypeEquals(ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.toText(expected), actual);
    }

    private static void assertMetadataTypeEquals(String expected, MetadataType actual) {
        Assert.assertThat((Object)expected, (Matcher)IsEqualCompressingWhiteSpace.equalToCompressingWhiteSpace((String)ComponentMetadataTypesDescriptorResultJsonSerializerTestCase.toText(actual)));
    }

    static String toText(MetadataType metadataType) {
        return new MetadataTypeWriter().toString(metadataType);
    }
}

