/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence.test;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.ComponentResultJsonSerializer;
import org.mule.runtime.extension.api.persistence.test.AbstractMetadataPersistenceTestCase;

public class OperationMetadataResultPersistenceTestCase
extends AbstractMetadataPersistenceTestCase {
    private static final String METADATA_OPERATION_RESULT_JSON = "/metadata/success-result-operation-descriptor.json";
    private ComponentMetadataDescriptor<OperationModel> operationMetadataDescriptor;
    private final ComponentResultJsonSerializer<OperationModel> metadataDescriptorSerializer = new ComponentResultJsonSerializer(true, true);

    @Override
    @Before
    public void setUp() throws IOException {
        super.setUp();
        this.operationMetadataDescriptor = this.buildTestOperationMetadataDescriptor();
    }

    @Test
    public void serializeSuccessMetadataDescriptorResult() throws IOException {
        MetadataResult success = MetadataResult.success(this.operationMetadataDescriptor);
        String serialized = this.metadataDescriptorSerializer.serialize(success);
        this.assertSerializedJson(serialized, METADATA_OPERATION_RESULT_JSON);
    }

    @Test
    public void deserializeOperationMetadataDescriptorResult() throws IOException {
        String resource = this.getResourceAsString(METADATA_OPERATION_RESULT_JSON);
        MetadataResult metadataResult = this.metadataDescriptorSerializer.deserialize(resource);
        MatcherAssert.assertThat((Object)metadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((OperationModel)((ComponentMetadataDescriptor)metadataResult.get()).getModel()), (Matcher)CoreMatchers.is((Object)this.getCarOperation));
        this.assertMetadataAttributes(((ComponentMetadataDescriptor)metadataResult.get()).getMetadataAttributes(), this.attributes);
    }

    private ComponentMetadataDescriptor<OperationModel> buildTestOperationMetadataDescriptor() {
        return ComponentMetadataDescriptor.builder((ComponentModel)this.getCarOperation).withAttributes(this.attributes).build();
    }
}

