/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.util;

import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.extension.internal.util.HierarchyClassMap;

public class HierarchyClassMapTestCase {
    private HierarchyClassMap<Object> map = new HierarchyClassMap();
    private Class[] keys = new Class[]{Dog.class, RabidDog.class, Human.class};

    @Before
    public void before() throws Exception {
        for (Class key : this.keys) {
            this.map.put(key, key.newInstance());
        }
    }

    @Test
    public void specificGet() {
        Stream.of(this.keys).forEach(key -> Assert.assertThat((Object)this.map.get(key), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf((Class)key))));
    }

    @Test
    public void specificContainsKey() {
        Stream.of(this.keys).forEach(key -> Assert.assertThat((Object)this.map.containsKey(key), (Matcher)CoreMatchers.is((Object)true)));
    }

    @Test
    public void hierarchicalGet() {
        Assert.assertThat((Object)this.map.get(RabidDog.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RabidDog.class)));
        this.map.remove(Dog.class);
        Assert.assertThat((Object)this.map.get(Dog.class), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RabidDog.class)));
    }

    @Test
    public void hierarchicalContainsKey() {
        Assert.assertThat((Object)this.map.containsKey(RabidDog.class), (Matcher)CoreMatchers.is((Object)true));
        this.map.remove(Dog.class);
        Assert.assertThat((Object)this.map.containsKey(Dog.class), (Matcher)CoreMatchers.is((Object)true));
    }

    public static class Human {
    }

    public static class RabidDog
    extends Dog {
    }

    public static class Dog {
    }
}

