/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.model.ExtensibleType;
import org.mule.runtime.extension.api.dsl.model.SubType;
import org.mule.runtime.extension.api.dsl.model.SuperType;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseXmlDeclarationTestCase {
    static final String PREFIX = "mockns";
    static final String NAMESPACE = "http://www.mulesoft.org/schema/mule/mockns";
    static final String SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/mockns/current/mule-mockns.xsd";
    static final String PARAMETER_NAME = "myCamelCaseName";
    static final String COLLECTION_NAME = "myCamelCaseNames";
    static final String SINGULARIZABLE_PARAMETER_NAME = "singularizableNames";
    static final String EXTENSION_NAME = "extension";
    static final String OPERATION_NAME = "mockOperation";
    static final String SOURCE_NAME = "source";
    static final String CONFIGURATION_NAME = "test";
    static final String CONNECTION_PROVIDER_NAME = "test";
    static final BaseTypeBuilder TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    static final String EXTENSIBLE_TYPE_LIST_NAME = "extensibleTypeList";
    static final String IMPORT_PREFIX = "importns";
    static final String IMPORT_NAMESPACE = "http://www.mulesoft.org/schema/mule/importns";
    static final String IMPORT_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/importns/current/mule-importns.xsd";
    static final String IMPORT_WITH_XML_SCHEMA_LOCATION = "http://www.mulesoft.org/schema/mule/importns/current/mule-import-extension-with-xml.xsd";
    static final String IMPORT_EXTENSION_NAME = "importExtension";
    static final String IMPORT_EXTENSION_NAME_WITH_XML = "importExtensionWithXml";
    @Mock
    protected ExtensionModel extension;
    @Mock
    protected ConfigurationModel configuration;
    @Mock
    protected OperationModel operation;
    @Mock
    protected ConnectionProviderModel connectionProvider;
    @Mock
    protected ParameterModel parameterModel;
    @Mock
    protected ParameterGroupModel parameterGroupModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected SourceModel source;
    @Mock
    protected DslResolvingContext dslContext;
    @Mock
    protected TypeCatalog typeCatalog;
    protected final ParameterRole role;
    protected ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected SubTypesModel subTypesModel = new SubTypesModel(this.TYPE_LOADER.load(SuperType.class), Collections.singleton(this.TYPE_LOADER.load(SubType.class)));

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ParameterRole.BEHAVIOUR}, {ParameterRole.CONTENT}, {ParameterRole.PRIMARY_CONTENT});
    }

    public BaseXmlDeclarationTestCase(ParameterRole role) {
        this.role = role;
    }

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.extension.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.extension.getXmlDslModel()).thenReturn((Object)this.createXmlDslModel());
        Mockito.when((Object)this.extension.getConfigurationModels()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.extension.getSubTypes()).thenReturn(Collections.singleton(this.subTypesModel));
        Mockito.when((Object)this.extension.getImportedTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extension.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(PREFIX).setNamespace(NAMESPACE).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("").build());
        Mockito.when((Object)this.configuration.getOperationModels()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getSourceModels()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)this.parameterModel.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)this.parameterModel.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)this.parameterModel.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)this.parameterModel.getRole()).thenReturn((Object)this.role);
        Mockito.when((Object)this.parameterGroupModel.getName()).thenReturn((Object)"GENERAL");
        Mockito.when((Object)this.parameterGroupModel.isShowInDsl()).thenReturn((Object)false);
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.source.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operation.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operation.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operation, this.source});
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)"test");
        Mockito.when((Object)this.configuration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)"test");
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)this.typeCatalog.getSubTypes((ObjectType)Matchers.any())).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getSuperTypes((ObjectType)Matchers.any())).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getAllBaseTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getAllSubTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getTypes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.typeCatalog.getType((String)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.typeCatalog.containsBaseType((ObjectType)Matchers.any())).thenReturn((Object)false);
        Mockito.when((Object)this.dslContext.getExtension((String)Matchers.any())).thenReturn(Optional.of(this.extension));
        Mockito.when((Object)this.dslContext.getExtensions()).thenReturn(Collections.singleton(this.extension));
        Mockito.when((Object)this.dslContext.getTypeCatalog()).thenReturn((Object)this.typeCatalog);
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> Mockito.when((Object)model.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel)));
    }

    void assertParameterChildElementDeclaration(boolean expected, DslElementSyntax result) {
        if (ExtensionModelUtils.isContent((ParameterModel)this.parameterModel)) {
            expected = true;
        }
        this.assertChildElementDeclarationIs(expected, result);
    }

    void assertChildElementDeclarationIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)String.format("Expected 'supportsChildDeclaration' declaration to be %s", expected), (Object)result.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertTopLevelDeclarationSupportIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)String.format("Expected 'supportsTopLevelDeclaration' declaration to be %s", expected), (Object)result.supportsTopLevelDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertIsWrappedElement(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)String.format("Expected 'isWrapped' declaration to be %s", expected), (Object)result.isWrapped(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertAttributeDeclaration(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)String.format("Expected 'supportsAttributeDeclaration' declaration to be %s", expected), (Object)result.supportsAttributeDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    void assertAttributeName(String expected, DslElementSyntax result) {
        this.assertAttributeDeclaration(true, result);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertEmptyAttributeName(DslElementSyntax result) {
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
    }

    void assertElementName(String expected, DslElementSyntax result) {
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertElementNamespace(String expected, DslElementSyntax result) {
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    void assertTopElementDeclarationIs(boolean expected, DslElementSyntax result) {
        Assert.assertThat((String)"Expected the element to support Top Level definitions", (Object)result.supportsTopLevelDeclaration(), (Matcher)CoreMatchers.is((Object)expected));
    }

    DslSyntaxResolver getSyntaxResolver() {
        return DslSyntaxResolver.getDefault((ExtensionModel)this.extension, (DslResolvingContext)this.dslContext);
    }

    protected void assertComplexTypeDslFields(DslElementSyntax topDsl) {
        this.assertExtensibleListParameter(topDsl);
        this.assertRecursiveChildParameter(topDsl);
        this.assertComplexTypeFromGroupRecursion(topDsl);
        this.assertSimplePojoField(topDsl);
        this.assertNonGlobalTypePojo(topDsl);
        this.assertGroupedTextField(topDsl);
        this.assertContentInsideGroup(topDsl);
        this.assertSkippedGroupFields(topDsl);
    }

    private void assertContentInsideGroup(DslElementSyntax topDsl) {
        String groupedFieldAsContent = "anotherGroupedFieldAsContent";
        DslElementSyntax anotherGroupedFieldDsl = this.getChildFieldDsl(groupedFieldAsContent, topDsl);
        Assert.assertThat((Object)topDsl.getAttribute(groupedFieldAsContent).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        this.assertElementName(NameUtils.hyphenize((String)groupedFieldAsContent), anotherGroupedFieldDsl);
        this.assertElementNamespace(PREFIX, anotherGroupedFieldDsl);
        this.assertChildElementDeclarationIs(true, anotherGroupedFieldDsl);
        this.assertIsWrappedElement(false, anotherGroupedFieldDsl);
        this.assertNoAttributes(anotherGroupedFieldDsl);
        this.assertNoChilds(anotherGroupedFieldDsl);
    }

    private void assertSkippedGroupFields(DslElementSyntax topDsl) {
        String parameterGroupType = "parameterGroupType";
        Assert.assertThat((Object)topDsl.getChild(parameterGroupType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)topDsl.getAttribute(parameterGroupType).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        String complexTypeFieldGroup = "complexTypeFieldGroup";
        Assert.assertThat((Object)topDsl.getChild(complexTypeFieldGroup).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)topDsl.getAttribute(complexTypeFieldGroup).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertGroupedTextField(DslElementSyntax topDsl) {
        String groupedField = "groupedField";
        Assert.assertThat((Object)topDsl.getAttribute(groupedField).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax groupedFieldDsl = this.getChildFieldDsl(groupedField, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)groupedField), groupedFieldDsl);
        this.assertElementNamespace(PREFIX, groupedFieldDsl);
        this.assertChildElementDeclarationIs(true, groupedFieldDsl);
        this.assertIsWrappedElement(false, groupedFieldDsl);
    }

    private void assertNonGlobalTypePojo(DslElementSyntax topDsl) {
        String notGlobalName = "notGlobalType";
        DslElementSyntax notGlobalAttrDsl = this.getAttributeDsl(notGlobalName, topDsl);
        this.assertAttributeDeclaration(true, notGlobalAttrDsl);
        this.assertAttributeName(notGlobalName, notGlobalAttrDsl);
        DslElementSyntax notGlobalDsl = this.getChildFieldDsl(notGlobalName, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)notGlobalName), notGlobalDsl);
        this.assertElementNamespace(PREFIX, notGlobalDsl);
        this.assertChildElementDeclarationIs(true, notGlobalDsl);
        this.assertIsWrappedElement(false, notGlobalDsl);
    }

    private void assertSimplePojoField(DslElementSyntax topDsl) {
        String simplePojoName = "simplePojo";
        DslElementSyntax simplePojoAttrDsl = this.getAttributeDsl(simplePojoName, topDsl);
        this.assertAttributeDeclaration(true, simplePojoAttrDsl);
        this.assertAttributeName(simplePojoName, simplePojoAttrDsl);
        DslElementSyntax simplePojoDsl = this.getChildFieldDsl(simplePojoName, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)simplePojoName), simplePojoDsl);
        this.assertElementNamespace(PREFIX, simplePojoDsl);
        this.assertChildElementDeclarationIs(true, simplePojoDsl);
        this.assertIsWrappedElement(false, simplePojoDsl);
        this.assertTopElementDeclarationIs(false, simplePojoDsl);
        String sampleStringName = "sampleString";
        Assert.assertThat((Object)topDsl.getChild(sampleStringName).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax sampleStringAttrDsl = this.getAttributeDsl(sampleStringName, simplePojoDsl);
        this.assertAttributeName(sampleStringName, sampleStringAttrDsl);
        this.assertElementName("", sampleStringAttrDsl);
        this.assertElementNamespace("", sampleStringAttrDsl);
        this.assertChildElementDeclarationIs(false, sampleStringAttrDsl);
        this.assertIsWrappedElement(false, sampleStringAttrDsl);
        this.assertNoAttributes(sampleStringAttrDsl);
        this.assertNoChilds(sampleStringAttrDsl);
        String otherNumberName = "otherNumber";
        Assert.assertThat((Object)topDsl.getChild(otherNumberName).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax otherNumberAttrDsl = this.getAttributeDsl(otherNumberName, simplePojoDsl);
        this.assertAttributeName(otherNumberName, otherNumberAttrDsl);
        this.assertElementName("", otherNumberAttrDsl);
        this.assertElementNamespace("", otherNumberAttrDsl);
        this.assertChildElementDeclarationIs(false, otherNumberAttrDsl);
        this.assertIsWrappedElement(false, otherNumberAttrDsl);
        this.assertNoAttributes(otherNumberAttrDsl);
        this.assertNoChilds(otherNumberAttrDsl);
        String textFieldName = "textField";
        Assert.assertThat((Object)topDsl.getAttribute(textFieldName).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax textFieldDsl = this.getChildFieldDsl(textFieldName, simplePojoDsl);
        this.assertAttributeDeclaration(false, textFieldDsl);
        this.assertElementName(NameUtils.hyphenize((String)textFieldName), textFieldDsl);
        this.assertElementNamespace(PREFIX, textFieldDsl);
        this.assertChildElementDeclarationIs(true, textFieldDsl);
        this.assertIsWrappedElement(false, textFieldDsl);
        this.assertTopElementDeclarationIs(false, textFieldDsl);
        this.assertNoAttributes(textFieldDsl);
        this.assertNoChilds(textFieldDsl);
    }

    protected void assertNoChilds(DslElementSyntax textFieldDsl) {
        Assert.assertThat((Object)textFieldDsl.getChilds().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertComplexTypeFromGroupRecursion(DslElementSyntax topDsl) {
        String recursiveFromGroupName = "complexFieldsType";
        DslElementSyntax recursiveFromGroupAttrDsl = this.getAttributeDsl(recursiveFromGroupName, topDsl);
        this.assertAttributeDeclaration(true, recursiveFromGroupAttrDsl);
        this.assertAttributeName(recursiveFromGroupName, recursiveFromGroupAttrDsl);
        DslElementSyntax recursiveFromGroupDsl = this.getChildFieldDsl(recursiveFromGroupName, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)recursiveFromGroupName), recursiveFromGroupDsl);
        this.assertElementNamespace(PREFIX, recursiveFromGroupDsl);
        this.assertChildElementDeclarationIs(true, recursiveFromGroupDsl);
        this.assertTopLevelDeclarationSupportIs(false, recursiveFromGroupDsl);
        this.assertIsWrappedElement(false, recursiveFromGroupDsl);
    }

    private void assertExtensibleListParameter(DslElementSyntax topDsl) {
        DslElementSyntax listAttrDsl = this.getAttributeDsl(EXTENSIBLE_TYPE_LIST_NAME, topDsl);
        this.assertAttributeDeclaration(true, listAttrDsl);
        this.assertAttributeName(EXTENSIBLE_TYPE_LIST_NAME, listAttrDsl);
        DslElementSyntax listDsl = this.getChildFieldDsl(EXTENSIBLE_TYPE_LIST_NAME, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)EXTENSIBLE_TYPE_LIST_NAME), listDsl);
        this.assertElementNamespace(PREFIX, listDsl);
        this.assertChildElementDeclarationIs(true, listDsl);
        this.assertIsWrappedElement(false, listDsl);
        MetadataType listItemType = this.TYPE_LOADER.load(ExtensibleType.class);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(listItemType, listDsl);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)listItemType), listItemDsl);
        this.assertElementNamespace(PREFIX, listItemDsl);
        this.assertChildElementDeclarationIs(true, listItemDsl);
        this.assertTopElementDeclarationIs(false, listItemDsl);
        this.assertIsWrappedElement(true, listItemDsl);
        this.assertNoAttributes(listItemDsl);
        this.assertNoChilds(listItemDsl);
    }

    protected void assertExtensibleTypeDslStructure(DslElementSyntax extensibleTypeDsl) {
        MetadataType type = this.TYPE_LOADER.load(ExtensibleType.class);
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), extensibleTypeDsl);
        this.assertChildElementDeclarationIs(true, extensibleTypeDsl);
        this.assertTopElementDeclarationIs(false, extensibleTypeDsl);
        this.assertIsWrappedElement(true, extensibleTypeDsl);
        String sampleStringName = "sampleString";
        Assert.assertThat((Object)extensibleTypeDsl.getChild(sampleStringName).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax sampleStringAttrDsl = this.getAttributeDsl(sampleStringName, extensibleTypeDsl);
        this.assertAttributeName(sampleStringName, sampleStringAttrDsl);
        this.assertElementName("", sampleStringAttrDsl);
        this.assertElementNamespace("", sampleStringAttrDsl);
        this.assertChildElementDeclarationIs(false, sampleStringAttrDsl);
        this.assertIsWrappedElement(false, sampleStringAttrDsl);
        this.assertNoAttributes(sampleStringAttrDsl);
        Assert.assertThat((Object)sampleStringAttrDsl.getChilds().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        String otherNumberName = "otherNumber";
        Assert.assertThat((Object)extensibleTypeDsl.getChild(otherNumberName).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax otherNumberAttrDsl = this.getAttributeDsl(otherNumberName, extensibleTypeDsl);
        this.assertAttributeName(otherNumberName, otherNumberAttrDsl);
        this.assertElementName("", otherNumberAttrDsl);
        this.assertElementNamespace("", otherNumberAttrDsl);
        this.assertChildElementDeclarationIs(false, otherNumberAttrDsl);
        this.assertIsWrappedElement(false, otherNumberAttrDsl);
        Assert.assertThat((Object)otherNumberAttrDsl.getAttributes().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)otherNumberAttrDsl.getChilds().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        String childNumbersName = "childNumbers";
        DslElementSyntax childNumbersAttrDsl = this.getAttributeDsl(childNumbersName, extensibleTypeDsl);
        this.assertAttributeName(childNumbersName, childNumbersAttrDsl);
        DslElementSyntax childNumbersListDsl = this.getChildFieldDsl(childNumbersName, extensibleTypeDsl);
        this.assertElementName(NameUtils.hyphenize((String)childNumbersName), childNumbersListDsl);
        this.assertChildElementDeclarationIs(true, childNumbersListDsl);
        this.assertIsWrappedElement(false, childNumbersListDsl);
        this.assertNoAttributes(childNumbersListDsl);
        this.assertNoChilds(childNumbersListDsl);
        MetadataType listItemType = this.TYPE_LOADER.load(Integer.class);
        DslElementSyntax listItemDsl = this.getGenericTypeDsl(listItemType, childNumbersListDsl);
        this.assertElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)childNumbersName)), listItemDsl);
        this.assertAttributeDeclaration(false, listItemDsl);
        this.assertChildElementDeclarationIs(true, listItemDsl);
        this.assertIsWrappedElement(false, listItemDsl);
        this.getAttributeDsl("value", listItemDsl);
        this.assertNoChilds(listItemDsl);
    }

    protected void assertNoAttributes(DslElementSyntax otherNumberListDsl) {
        Assert.assertThat((Object)otherNumberListDsl.getAttributes().isEmpty(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertRecursiveChildParameter(DslElementSyntax topDsl) {
        String recursiveChildName = "recursiveChild";
        DslElementSyntax recursiveAttrChildDsl = this.getAttributeDsl(recursiveChildName, topDsl);
        this.assertAttributeDeclaration(true, recursiveAttrChildDsl);
        this.assertAttributeName(recursiveChildName, recursiveAttrChildDsl);
        DslElementSyntax recursiveChildDsl = this.getChildFieldDsl(recursiveChildName, topDsl);
        this.assertElementName(NameUtils.hyphenize((String)recursiveChildName), recursiveChildDsl);
        this.assertElementNamespace(PREFIX, recursiveChildDsl);
        this.assertChildElementDeclarationIs(true, recursiveChildDsl);
        this.assertTopLevelDeclarationSupportIs(false, recursiveChildDsl);
        this.assertIsWrappedElement(false, recursiveChildDsl);
    }

    protected DslElementSyntax getGenericTypeDsl(MetadataType itemType, DslElementSyntax result) {
        Optional genericDsl = result.getGeneric(itemType);
        Assert.assertThat((String)("No generic element found for type [" + MetadataTypeUtils.getTypeId((MetadataType)itemType).orElse("") + "] for element [" + result.getElementName() + "]"), (Object)genericDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementSyntax)genericDsl.get();
    }

    protected DslElementSyntax getAttributeDsl(String name, DslElementSyntax parent) {
        Optional childDsl = parent.getAttribute(name);
        Assert.assertThat((String)("No attribute element found with name [" + name + "] for element [" + parent.getElementName() + "]"), (Object)childDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementSyntax)childDsl.get();
    }

    protected DslElementSyntax getChildFieldDsl(String name, DslElementSyntax parent) {
        Optional childDsl = parent.getChild(name);
        Assert.assertThat((String)("No child element found with name [" + name + "] for element [" + parent.getElementName() + "]"), (Object)childDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        return (DslElementSyntax)childDsl.get();
    }

    protected void mockImportedTypes(String originExtension, Class<?> type) {
        Mockito.when((Object)this.extension.getImportedTypes()).thenReturn(Collections.singleton(new ImportedTypeModel(originExtension, this.TYPE_LOADER.load(type))));
    }

    protected void ifContentParameter(Runnable test, Runnable orElse) {
        if (ExtensionModelUtils.isContent((ParameterModel)this.parameterModel)) {
            test.run();
        } else {
            orElse.run();
        }
    }

    protected XmlDslModel createXmlDslModel() {
        return XmlDslModel.builder().setXsdFileName("mule-mockns.xsd").setPrefix(PREFIX).setNamespace(NAMESPACE).setSchemaLocation(SCHEMA_LOCATION).setSchemaVersion("4.0").build();
    }

    protected XmlDslModel createImportedXmlDslModel() {
        return XmlDslModel.builder().setXsdFileName("mule-importns.xsd").setPrefix(IMPORT_PREFIX).setNamespace(IMPORT_NAMESPACE).setSchemaLocation(IMPORT_SCHEMA_LOCATION).setSchemaVersion("4.0").build();
    }

    protected ParameterModel mockBehaviourParam(String name, Class<?> clazz) {
        ParameterModel model = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)model.getName()).thenReturn((Object)name);
        Mockito.when((Object)model.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)model.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)model.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)model.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)model.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)model.getType()).thenReturn((Object)this.TYPE_LOADER.load(clazz));
        return model;
    }

    @Extension(name="importExtension")
    protected static final class ExtensionForImportsNoXml {
        protected ExtensionForImportsNoXml() {
        }
    }

    @Xml(prefix="importns", namespace="http://www.mulesoft.org/schema/mule/importns")
    @Extension(name="importExtensionWithXml")
    protected static final class ExtensionForImportsDeclaresXml {
        protected ExtensionForImportsDeclaresXml() {
        }
    }
}

