/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.Arrays;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.dsl.model.ComplexFieldsType;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.NameUtils;

@RunWith(value=Parameterized.class)
public class ComponentsXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    private static final String COMPLEX_PARAMETER = "complexParameter";
    private static final String GROUPED_COMPLEX_PARAMETER = "groupedComplexParameter";
    private static final String SIMPLE_PARAMETER = "simpleParameter";
    private static final String INLINE_GROUP = "inlineGroup";

    public ComponentsXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Before
    public void enrichParameters() {
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        ParameterModel complexParameterModel = this.mockBehaviourParam(COMPLEX_PARAMETER, ComplexFieldsType.class);
        Mockito.when((Object)this.parameterGroupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel, complexParameterModel));
        ParameterModel simpleParameterModel = this.mockBehaviourParam(SIMPLE_PARAMETER, Integer.class);
        ParameterModel groupedComplexParameterModel = this.mockBehaviourParam(GROUPED_COMPLEX_PARAMETER, ComplexFieldsType.class);
        ParameterGroupModel inlineGroupModel = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)inlineGroupModel.getName()).thenReturn((Object)INLINE_GROUP);
        Mockito.when((Object)inlineGroupModel.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)inlineGroupModel.getParameterModels()).thenReturn(Arrays.asList(simpleParameterModel, groupedComplexParameterModel));
        Mockito.when((Object)this.source.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.operation.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.configuration.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
        Stream.of(this.configuration, this.operation, this.connectionProvider, this.source).forEach(model -> {
            Mockito.when((Object)this.connectionProvider.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel, inlineGroupModel));
            Mockito.when((Object)model.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel, complexParameterModel, simpleParameterModel, groupedComplexParameterModel));
        });
    }

    @Test
    public void testOperationDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"mockOperation")));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
        this.assertTopElementDeclarationIs(false, result);
        this.assertChildElementDeclarationIs(true, result);
        this.assertAttributeDeclaration(false, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testSourceDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.source);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"source")));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testConfigurationDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.configuration);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)"test-config"));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)false));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void testConfigurationDeclarationWithConfigSuffix() {
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)"testConfig");
        this.testConfigurationDeclaration();
    }

    @Test
    public void testDefaultConfigurationDeclarationWithConfigSuffix() {
        String defaultName = "config";
        Mockito.when((Object)this.configuration.getName()).thenReturn((Object)defaultName);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.configuration);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)defaultName));
    }

    @Test
    public void testConnectionProviderDeclarationWithConnectionSuffix() {
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)"testConnection");
        this.testConnectionProviderDeclaration();
    }

    @Test
    public void testDefaultConnectionProviderDeclarationWithConnectionSuffix() {
        String defaultName = "connection";
        Mockito.when((Object)this.connectionProvider.getName()).thenReturn((Object)defaultName);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.connectionProvider);
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)defaultName));
    }

    @Test
    public void testConnectionProviderDeclaration() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.connectionProvider);
        Assert.assertThat((Object)result.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)result.getElementName(), (Matcher)CoreMatchers.is((Object)"test-connection"));
        Assert.assertThat((Object)result.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)false));
        this.assertChildElementDeclarationIs(true, result);
        this.assertIsWrappedElement(false, result);
        this.assertStringTypeComponentParameter(result);
        this.assertComplexTypeComponentParameter(result);
        this.assertInlineParameterGroup(result);
    }

    @Test
    public void connectedOperation() {
        Mockito.when((Object)this.operation.requiresConnection()).thenReturn((Object)true);
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Assert.assertThat((Object)result.requiresConfig(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void assertStringTypeComponentParameter(DslElementSyntax result) {
        this.ifContentParameter(() -> Assert.assertThat((Object)result.getChild("myCamelCaseName").isPresent(), (Matcher)CoreMatchers.is((Object)true)), () -> {
            DslElementSyntax childDsl = this.getAttributeDsl("myCamelCaseName", result);
            this.assertAttributeName("myCamelCaseName", childDsl);
            this.assertParameterChildElementDeclaration(false, childDsl);
            this.assertIsWrappedElement(false, childDsl);
        });
    }

    private void assertInlineParameterGroup(DslElementSyntax result) {
        Assert.assertThat((Object)result.getAttribute(INLINE_GROUP).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        DslElementSyntax inlineDsl = this.getChildFieldDsl(INLINE_GROUP, result);
        Assert.assertThat((Object)inlineDsl.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)INLINE_GROUP)));
        Assert.assertThat((Object)inlineDsl.getPrefix(), (Matcher)CoreMatchers.is((Object)"mockns"));
        this.assertChildElementDeclarationIs(true, inlineDsl);
        this.assertTopElementDeclarationIs(false, inlineDsl);
        this.assertAttributeDeclaration(false, inlineDsl);
        this.assertIsWrappedElement(false, inlineDsl);
        DslElementSyntax attributeDsl = this.getAttributeDsl(SIMPLE_PARAMETER, inlineDsl);
        Assert.assertThat((Object)result.getChild(SIMPLE_PARAMETER).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        this.assertAttributeName(SIMPLE_PARAMETER, attributeDsl);
        this.assertElementName("", attributeDsl);
        this.assertElementNamespace("", attributeDsl);
        this.assertChildElementDeclarationIs(false, attributeDsl);
        this.assertIsWrappedElement(false, attributeDsl);
        this.assertNoAttributes(attributeDsl);
        this.assertNoChilds(attributeDsl);
        DslElementSyntax complexAttributeDsl = this.getAttributeDsl(GROUPED_COMPLEX_PARAMETER, inlineDsl);
        this.assertAttributeName(GROUPED_COMPLEX_PARAMETER, complexAttributeDsl);
        DslElementSyntax childDsl = this.getChildFieldDsl(GROUPED_COMPLEX_PARAMETER, inlineDsl);
        this.assertComplexTypeDslFields(childDsl);
    }

    private void assertComplexTypeComponentParameter(DslElementSyntax result) {
        DslElementSyntax attributeDsl = this.getAttributeDsl(COMPLEX_PARAMETER, result);
        this.assertAttributeName(COMPLEX_PARAMETER, attributeDsl);
        DslElementSyntax childDsl = this.getChildFieldDsl(COMPLEX_PARAMETER, result);
        this.assertComplexTypeDslFields(childDsl);
    }
}

