/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.FunctionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestableElementDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedChainDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.construct.ImmutableConstructModel;
import org.mule.runtime.extension.api.model.function.ImmutableFunctionModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedChainModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedComponentModel;
import org.mule.runtime.extension.api.model.nested.ImmutableNestedRouteModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceCallbackModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.ParameterModelComparator;
import org.mule.runtime.extension.internal.loader.enricher.ClassLoaderDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ConnectionProviderDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ContentParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ExecutionTypeDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ExtensionTypesDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.OAuthDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.ReconnectionStrategyDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.StreamingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.TargetParameterDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.TransactionalDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.enricher.XmlDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.validator.ConnectionProviderNameModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ContentParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ExclusiveParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.FunctionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.NameClashModelValidator;
import org.mule.runtime.extension.internal.loader.validator.OperationParametersModelValidator;
import org.mule.runtime.extension.internal.loader.validator.ParameterModelValidator;
import org.mule.runtime.extension.internal.loader.validator.SourceCallbacksModelValidator;
import org.mule.runtime.extension.internal.loader.validator.SubtypesModelValidator;
import org.mule.runtime.extension.internal.loader.validator.TransactionalParametersValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionModelFactory {
    private final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelFactory.class);
    private final List<DeclarationEnricher> declarationEnrichers = Collections.unmodifiableList(Arrays.asList(new ClassLoaderDeclarationEnricher(), new ContentParameterDeclarationEnricher(), new ExecutionTypeDeclarationEnricher(), new ExtensionTypesDeclarationEnricher(), new XmlDeclarationEnricher(), new TargetParameterDeclarationEnricher(), new ConnectionProviderDeclarationEnricher(), new ReconnectionStrategyDeclarationEnricher(), new StreamingDeclarationEnricher(), new OAuthDeclarationEnricher(), new TransactionalDeclarationEnricher()));
    private final List<ExtensionModelValidator> extensionModelValidators = Collections.unmodifiableList(Arrays.asList(new ConnectionProviderNameModelValidator(), new ContentParameterModelValidator(), new ExclusiveParameterModelValidator(), new NameClashModelValidator(), new OperationParametersModelValidator(), new FunctionModelValidator(), new ParameterModelValidator(), new SubtypesModelValidator(), new SourceCallbacksModelValidator(), new TransactionalParametersValidator()));

    public ExtensionModel create(ExtensionLoadingContext extensionLoadingContext) {
        this.enrichModel(extensionLoadingContext);
        ExtensionModel extensionModel = new FactoryDelegate().toExtension((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
        ProblemsReporter problemsReporter = new ProblemsReporter(extensionModel);
        this.validate(extensionModel, problemsReporter, extensionLoadingContext);
        if (problemsReporter.hasErrors()) {
            throw new IllegalModelDefinitionException(String.format("Extension '%s' has definition errors:\n%s", extensionModel.getName(), problemsReporter.toString()));
        }
        if (problemsReporter.hasWarnings() && this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(String.format("Extension '%s' has definition warnings:\n%s", extensionModel.getName(), problemsReporter.getWarningsAsString()));
        }
        return extensionModel;
    }

    private void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter, ExtensionLoadingContext extensionLoadingContext) {
        LinkedList<ExtensionModelValidator> validators = new LinkedList<ExtensionModelValidator>(this.extensionModelValidators);
        validators.addAll(extensionLoadingContext.getCustomValidators());
        validators.forEach(v -> v.validate(extensionModel, problemsReporter));
    }

    private void validateMuleVersion(ExtensionDeclaration extensionDeclaration) {
        String version = extensionDeclaration.getVersion();
        if (version == null || version.trim().length() == 0) {
            throw new IllegalModelDefinitionException(String.format("Extension '%s' did not specified a version", extensionDeclaration.getName()));
        }
        try {
            new MuleVersion(version);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid version '%s' for extension '%s'", version, extensionDeclaration.getName()));
        }
    }

    private void enrichModel(ExtensionLoadingContext extensionLoadingContext) {
        LinkedList<DeclarationEnricher> enrichers = new LinkedList<DeclarationEnricher>(extensionLoadingContext.getCustomDeclarationEnrichers());
        enrichers.addAll(this.declarationEnrichers);
        enrichers.forEach(enricher -> enricher.enrich(extensionLoadingContext));
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private Set<ObjectType> toExtensionTypes(Set<ObjectType> types, Set<ImportedTypeModel> importedTypes) {
        Set importedTypesIds = importedTypes.stream().map(ImportedTypeModel::getImportedType).map(ExtensionMetadataTypeUtils::getId).collect(Collectors.toSet());
        return types.stream().filter(t -> !importedTypesIds.contains(ExtensionMetadataTypeUtils.getId((MetadataType)t))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private class FactoryDelegate {
        private Cache<ParameterizedDeclaration, ParameterizedModel> modelCache = CacheBuilder.newBuilder().build();

        private FactoryDelegate() {
        }

        private ExtensionModel toExtension(ExtensionDeclaration extensionDeclaration) {
            ExtensionModelFactory.this.validateMuleVersion(extensionDeclaration);
            ImmutableExtensionModel extensionModel = new ImmutableExtensionModel(extensionDeclaration.getName(), extensionDeclaration.getDescription(), extensionDeclaration.getVersion(), extensionDeclaration.getVendor(), extensionDeclaration.getCategory(), extensionDeclaration.getMinMuleVersion(), this.sortConfigurations(this.toConfigurations(extensionDeclaration.getConfigurations())), this.toOperations(extensionDeclaration.getOperations()), this.toConnectionProviders(extensionDeclaration.getConnectionProviders()), this.toMessageSources(extensionDeclaration.getMessageSources()), this.toFunctions(extensionDeclaration.getFunctions()), this.toConstructs(extensionDeclaration.getConstructs()), extensionDeclaration.getDisplayModel(), extensionDeclaration.getXmlDslModel(), extensionDeclaration.getSubTypes(), ExtensionModelFactory.this.toExtensionTypes(extensionDeclaration.getTypes(), extensionDeclaration.getImportedTypes()), extensionDeclaration.getResources(), extensionDeclaration.getImportedTypes(), extensionDeclaration.getErrorModels(), extensionDeclaration.getExternalLibraryModels(), extensionDeclaration.getPrivilegedPackages(), extensionDeclaration.getPrivilegedArtifacts(), extensionDeclaration.getModelProperties());
            return extensionModel;
        }

        private List<ConfigurationModel> sortConfigurations(List<ConfigurationModel> configurationModels) {
            if (configurationModels.isEmpty()) {
                return configurationModels;
            }
            return NameUtils.alphaSortDescribedList(configurationModels);
        }

        private List<ConfigurationModel> toConfigurations(List<ConfigurationDeclaration> declarations) {
            return declarations.stream().map(this::toConfiguration).collect(Collectors.toList());
        }

        private <T extends ParameterizedModel> T fromCache(ParameterizedDeclaration declaration, Supplier<ParameterizedModel> supplier) {
            try {
                return (T)((ParameterizedModel)this.modelCache.get((Object)declaration, supplier::get));
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        private ConfigurationModel toConfiguration(ConfigurationDeclaration declaration) {
            return (ConfigurationModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableConfigurationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOperations(declaration.getOperations()), this.toConnectionProviders(declaration.getConnectionProviders()), this.toMessageSources(declaration.getMessageSources()), declaration.getExternalLibraryModels(), declaration.getDisplayModel(), declaration.getModelProperties()));
        }

        private List<ConstructModel> toConstructs(List<ConstructDeclaration> constructs) {
            return constructs.stream().map(this::toConstruct).collect(Collectors.toList());
        }

        private ConstructModel toConstruct(ConstructDeclaration declaration) {
            return (ConstructModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableConstructModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), declaration.allowsTopLevelDefinition(), declaration.getDisplayModel(), this.getProcessorStereotypes(declaration.getStereotypes()), declaration.getModelProperties()));
        }

        private List<SourceModel> toMessageSources(List<SourceDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toMessageSource).collect(Collectors.toList())));
        }

        private SourceModel toMessageSource(SourceDeclaration declaration) {
            return (SourceModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableSourceModel(declaration.getName(), declaration.getDescription(), declaration.hasResponse(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), this.toSourceCallback(declaration.getSuccessCallback()), this.toSourceCallback(declaration.getErrorCallback()), this.toSourceCallback(declaration.getTerminateCallback()), declaration.isRequiresConnection(), declaration.isTransactional(), declaration.isSupportsStreaming(), declaration.getDisplayModel(), this.getSourceStereotypes(declaration), declaration.getErrorModels(), declaration.getModelProperties()));
        }

        private Set<StereotypeModel> getSourceStereotypes(SourceDeclaration declaration) {
            if (!declaration.getStereotypes().isEmpty()) {
                return declaration.getStereotypes();
            }
            return ImmutableSet.of((Object)StereotypeModelBuilder.newStereotype((String)MuleStereotypes.SOURCE.getName(), (String)"mule".toUpperCase()).withParent(StereotypeModelBuilder.newStereotype((String)MuleStereotypes.ANY.getName(), (String)"mule".toUpperCase()).build()).build());
        }

        private Optional<SourceCallbackModel> toSourceCallback(Optional<SourceCallbackDeclaration> callbackDeclaration) {
            return callbackDeclaration.map(callback -> new ImmutableSourceCallbackModel(callback.getName(), callback.getDescription(), this.toParameterGroups(callback.getParameterGroups()), callback.getDisplayModel(), callback.getModelProperties()));
        }

        private Set<StereotypeModel> getProcessorStereotypes(Set<StereotypeModel> stereotypeModels) {
            if (!stereotypeModels.isEmpty()) {
                return stereotypeModels;
            }
            return ImmutableSet.of((Object)StereotypeModelBuilder.newStereotype((String)MuleStereotypes.PROCESSOR.name(), (String)"mule".toUpperCase()).withParent(StereotypeModelBuilder.newStereotype((String)MuleStereotypes.ANY.name(), (String)"mule".toUpperCase()).build()).build());
        }

        private List<OperationModel> toOperations(List<OperationDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toOperation).collect(Collectors.toList())));
        }

        private OperationModel toOperation(OperationDeclaration declaration) {
            return (OperationModel)this.fromCache((ParameterizedDeclaration)declaration, () -> {
                ImmutableOperationModel operation = new ImmutableOperationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toNestedComponentModels(declaration.getNestedComponents()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), declaration.isBlocking(), declaration.getExecutionType(), declaration.isRequiresConnection(), declaration.isTransactional(), declaration.isSupportsStreaming(), declaration.getDisplayModel(), declaration.getErrorModels(), this.getProcessorStereotypes(declaration.getStereotypes()), declaration.getModelProperties());
                return operation;
            });
        }

        private List<NestableElementModel> toNestedComponentModels(List<NestableElementDeclaration> nestedComponents) {
            return nestedComponents.stream().map(this::toNestedComponent).collect(Collectors.toList());
        }

        private NestableElementModel toNestedComponent(NestableElementDeclaration declaration) {
            if (declaration instanceof NestedRouteDeclaration) {
                return new ImmutableNestedRouteModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(((NestedRouteDeclaration)declaration).getParameterGroups()), declaration.getDisplayModel(), ((NestedRouteDeclaration)declaration).getMinOccurs(), ((NestedRouteDeclaration)declaration).getMaxOccurs(), this.toNestedComponentModels(((NestedRouteDeclaration)declaration).getNestedComponents()), declaration.getModelProperties());
            }
            if (declaration instanceof NestedChainDeclaration) {
                return new ImmutableNestedChainModel(declaration.getName(), declaration.getDescription(), declaration.getDisplayModel(), declaration.isRequired(), this.getProcessorStereotypes(((NestedChainDeclaration)declaration).getAllowedStereotypes()), declaration.getModelProperties());
            }
            return new ImmutableNestedComponentModel(declaration.getName(), declaration.getDescription(), declaration.getDisplayModel(), declaration.isRequired(), this.getProcessorStereotypes(((NestedComponentDeclaration)declaration).getAllowedStereotypes()), declaration.getModelProperties());
        }

        private List<ConnectionProviderModel> toConnectionProviders(List<ConnectionProviderDeclaration> declarations) {
            return Collections.unmodifiableList(NameUtils.alphaSortDescribedList(declarations.stream().map(this::toConnectionProvider).collect(Collectors.toList())));
        }

        private OutputModel toOutputModel(OutputDeclaration declaration) {
            return declaration != null ? new ImmutableOutputModel(declaration.getDescription(), declaration.getType(), declaration.hasDynamicType(), declaration.getModelProperties()) : new ImmutableOutputModel("", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build(), false, Collections.emptySet());
        }

        private ConnectionProviderModel toConnectionProvider(ConnectionProviderDeclaration declaration) {
            return (ConnectionProviderModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableConnectionProviderModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.getConnectionManagementType(), declaration.getExternalLibraryModels(), declaration.getDisplayModel(), declaration.getModelProperties()));
        }

        private List<ParameterGroupModel> toParameterGroups(List<ParameterGroupDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            declarations = new ArrayList<ParameterGroupDeclaration>(declarations);
            declarations.sort((left, right) -> {
                if ("General".equals(left.getName())) {
                    return -1;
                }
                if ("General".equals(right.getName())) {
                    return 1;
                }
                return 0;
            });
            return Collections.unmodifiableList(declarations.stream().map(this::toParameterGroup).collect(Collectors.toList()));
        }

        private ParameterGroupModel toParameterGroup(ParameterGroupDeclaration declaration) {
            return new ImmutableParameterGroupModel(declaration.getName(), declaration.getDescription(), this.toParameters(declaration.getParameters()), this.toExclusiveParametersModels(declaration), declaration.isShowInDsl(), declaration.getDisplayModel(), declaration.getLayoutModel(), declaration.getModelProperties());
        }

        private List<ExclusiveParametersModel> toExclusiveParametersModels(ParameterGroupDeclaration groupDeclaration) {
            return Collections.unmodifiableList(groupDeclaration.getExclusiveParameters().stream().map(exclusive -> new ImmutableExclusiveParametersModel(exclusive.getParameterNames(), exclusive.isRequiresOne())).collect(Collectors.toList()));
        }

        private List<ParameterModel> toParameters(List<ParameterDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            return Collections.unmodifiableList(declarations.stream().map(this::toParameter).sorted(new ParameterModelComparator(false)).collect(Collectors.toList()));
        }

        private ParameterModel toParameter(ParameterDeclaration parameter) {
            Object defaultValue = parameter.getDefaultValue();
            if (defaultValue instanceof String) {
                if (parameter.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && ExtensionModelFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is marked as not supporting expressions yet it contains one as a default value. Please fix this", parameter.getName()));
                }
                if (parameter.getExpressionSupport() == ExpressionSupport.REQUIRED && !ExtensionModelFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' requires expressions yet it contains a constant as a default value. Please fix this", parameter.getName()));
                }
            }
            return new ImmutableParameterModel(parameter.getName(), parameter.getDescription(), parameter.getType(), parameter.hasDynamicType(), parameter.isRequired(), parameter.isConfigOverride(), parameter.getExpressionSupport(), parameter.getDefaultValue(), parameter.getRole(), parameter.getDslConfiguration(), parameter.getDisplayModel(), parameter.getLayoutModel(), parameter.getValueProviderModel(), parameter.getElementReferences(), parameter.getModelProperties());
        }

        private List<FunctionModel> toFunctions(List<FunctionDeclaration> expressionFunctions) {
            return Collections.unmodifiableList(expressionFunctions.stream().map(declaration -> new ImmutableFunctionModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOutputModel(declaration.getOutput()), declaration.getDisplayModel(), declaration.getModelProperties())).collect(Collectors.toList()));
        }
    }
}

