/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.dsl.model.ComplexFieldsType;
import org.mule.runtime.extension.api.dsl.model.ExtensibleType;
import org.mule.runtime.extension.api.dsl.model.GlobalType;
import org.mule.runtime.extension.api.dsl.model.InterfaceDeclaration;
import org.mule.runtime.extension.api.dsl.model.NotGlobalType;
import org.mule.runtime.extension.api.dsl.model.RecursiveChainA;
import org.mule.runtime.extension.api.dsl.model.RecursiveChainB;
import org.mule.runtime.extension.api.dsl.model.RecursivePojo;
import org.mule.runtime.extension.api.dsl.model.SimpleFieldsType;
import org.mule.runtime.extension.api.dsl.model.SubstitutionGroupReferencingType;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.NameUtils;

@RunWith(value=Parameterized.class)
public class TypeXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    public TypeXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Test
    public void textField() {
        MetadataType type = this.TYPE_LOADER.load(SimpleFieldsType.class);
        DslElementSyntax typeSyntax = (DslElementSyntax)this.getSyntaxResolver().resolve(type).orElseThrow(() -> new RuntimeException("No dsl declaration found for the given type"));
        DslElementSyntax textFieldSyntax = (DslElementSyntax)typeSyntax.getChild("textField").get();
        Assert.assertThat((Object)textFieldSyntax.getElementName(), (Matcher)CoreMatchers.is((Object)"text-field"));
        Assert.assertThat((Object)textFieldSyntax.getAttributeName(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testRecursiveTypeAndChain() {
        MetadataType type = this.TYPE_LOADER.load(RecursivePojo.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        type = this.TYPE_LOADER.load(RecursiveChainA.class);
        topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        type = this.TYPE_LOADER.load(RecursiveChainB.class);
        topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testComplexRecursiveType() {
        MetadataType type = this.TYPE_LOADER.load(ComplexFieldsType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementNamespace("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
        this.assertComplexTypeDslFields((DslElementSyntax)topDsl.get());
    }

    @Test
    public void testNoGlobalType() {
        MetadataType type = this.TYPE_LOADER.load(NotGlobalType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementNamespace("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertTopElementDeclarationIs(false, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testGlobalType() {
        MetadataType type = this.TYPE_LOADER.load(GlobalType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementNamespace("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertTopElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }

    @Test
    public void testAbsentIfNotComplex() {
        MetadataType type = this.TYPE_LOADER.load(String.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration not expected but one was found", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testAbsentIfNotGlobalWrappedNorChild() {
        MetadataType type = this.TYPE_LOADER.load(InterfaceDeclaration.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((String)"Type dsl declaration not expected but one was found", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testExtensibleImportParameter() {
        ExtensionModel importOriginMock = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.mockImportedTypes(importOriginMock, "importExtensionWithXml", ExtensibleType.class);
        Mockito.when((Object)importOriginMock.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setXsdFileName("").setPrefix(NameUtils.defaultNamespace((String)"importExtensionWithXml")).setNamespace("http://www.mulesoft.org/schema/mule/importns").setXsdFileName("").setSchemaLocation("http://www.mulesoft.org/schema/mule/importns/current/mule-import-extension-with-xml.xsd").build());
        MetadataType paramType = this.TYPE_LOADER.load(ExtensibleType.class);
        Mockito.when((Object)this.dslContext.getExtension("importExtensionWithXml")).thenReturn(Optional.of(importOriginMock));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)paramType);
        Optional typeResult = this.getSyntaxResolver().resolve(paramType);
        Assert.assertThat((Object)typeResult.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementNamespace(NameUtils.defaultNamespace((String)"importExtensionWithXml"), (DslElementSyntax)typeResult.get());
        this.assertExtensibleTypeDslStructure((DslElementSyntax)typeResult.get());
    }

    @Test
    public void testSubstitutionGroupReferencingType() {
        MetadataType type = this.TYPE_LOADER.load(SubstitutionGroupReferencingType.class);
        Optional topDsl = this.getSyntaxResolver().resolve(type);
        Assert.assertThat((Object)((SubstitutionGroup)TypeUtils.getSubstitutionGroup((MetadataType)type).get()).getPrefix(), (Matcher)CoreMatchers.is((Object)"someprefix"));
        Assert.assertThat((Object)((SubstitutionGroup)TypeUtils.getSubstitutionGroup((MetadataType)type).get()).getElement(), (Matcher)CoreMatchers.is((Object)"some-element"));
        Assert.assertThat((String)"Type dsl declaration expected but none applied", (Object)topDsl.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        this.assertElementName(NameUtils.getTopLevelTypeName((MetadataType)type), (DslElementSyntax)topDsl.get());
        this.assertElementNamespace("mockns", (DslElementSyntax)topDsl.get());
        this.assertChildElementDeclarationIs(true, (DslElementSyntax)topDsl.get());
        this.assertIsWrappedElement(false, (DslElementSyntax)topDsl.get());
    }
}

