/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.tck.TestWebServiceConsumerDeclarer;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.internal.loader.BaseExtensionModelFactoryTestCase;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;

public class FlatExtensionModelFactoryTestCase
extends BaseExtensionModelFactoryTestCase {
    private static final MuleVersion MIN_MULE_VERSION = new MuleVersion("4.0");
    private final TestWebServiceConsumerDeclarer reference = new TestWebServiceConsumerDeclarer();
    private final MetadataType voidType = this.typeLoader.load(Void.TYPE);
    private final MetadataType stringType = this.typeLoader.load(String.class);
    private final MetadataType targetValue = this.typeLoader.load(String.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void before() {
        this.declare(this::declareBase);
        this.load();
    }

    @Test
    public void assertExtension() {
        Assert.assertThat((Object)this.extensionModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"WSConsumer"));
        Assert.assertThat((Object)this.extensionModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Generic Consumer for SOAP Web Services"));
        Assert.assertThat((Object)this.extensionModel.getVersion(), (Matcher)CoreMatchers.equalTo((Object)"3.6.0"));
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionModel.getVendor(), (Matcher)CoreMatchers.equalTo((Object)"MuleSoft"));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        ConfigurationModel configurationModel = (ConfigurationModel)this.extensionModel.getConfigurationModel("config").get();
        Assert.assertThat((Object)configurationModel, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)configurationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"config"));
        Assert.assertThat((Object)configurationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Default description"));
        List parameterModels = configurationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)4));
        this.assertParameter((ParameterModel)parameterModels.get(0), "address", "Service address", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(1), "port", "Service Port", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(2), "service", "Service Name", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(3), "wsdlLocation", "URI to find the WSDL", ExpressionSupport.NOT_SUPPORTED, true, this.stringType, StringType.class, null);
    }

    @Test
    public void onlyOneConfig() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat(this.extensionModel.getConfigurationModels().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getConfigurationModel("config").get())));
    }

    public void noSuchConfiguration() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getConfigurationModel("fake").isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    public void noSuchOperation() throws Exception {
        Assert.assertThat((Object)this.extensionModel.getOperationModel("fake").isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void operations() throws Exception {
        List operationModels = this.extensionModel.getOperationModels();
        Assert.assertThat((Object)operationModels, (Matcher)Matchers.hasSize((int)3));
        this.assertConsumeOperation(operationModels);
        this.assertBroadcastOperation(operationModels);
        this.assertArglessOperation(operationModels);
    }

    @Test(expected=IllegalArgumentException.class)
    public void badExtensionVersion() {
        this.declare(declarer -> declarer.named("bad").onVersion("i'm new"));
        this.load();
    }

    @Test
    public void configurationsOrder() {
        String alpha = "alpha";
        String beta = "beta";
        String gamma = "gamma";
        this.declare(extensionDeclarer -> {
            extensionDeclarer.named("test").onVersion("1.0").fromVendor("MuleSoft").withCategory(Category.COMMUNITY).withMinMuleVersion(MIN_MULE_VERSION).withXmlDsl(XmlDslModel.builder().build());
            extensionDeclarer.withConfig("gamma").describedAs("gamma");
            extensionDeclarer.withConfig("beta").describedAs("beta");
            extensionDeclarer.withConfig("alpha").describedAs("alpha");
        });
        ExtensionModel extensionModel = this.load();
        List configurationModels = extensionModel.getConfigurationModels();
        Assert.assertThat((Object)configurationModels, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"alpha"));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"beta"));
        Assert.assertThat((Object)((ConfigurationModel)configurationModels.get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"gamma"));
    }

    @Test
    public void operationsAlphaSorted() {
        Assert.assertThat((Object)this.extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(0)).getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(1)).getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)((OperationModel)this.extensionModel.getOperationModels().get(2)).getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void nameClashes() {
        this.declare(extensionDeclarer -> this.reference.declareOn(extensionDeclarer).withConfig("config").describedAs(""));
        this.load();
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void fixedParameterWithExpressionDefault() {
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            operation.withOutput().ofType(this.stringType);
            operation.withOutputAttributes().ofType(this.voidType);
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onDefaultParameterGroup().withOptionalParameter("fixed").ofType(this.stringType)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"#['hello']");
        });
        this.load();
    }

    public void operationWithParameterNamedTarget() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)"The following operations have parameters named after reserved words"));
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            operation.onDefaultParameterGroup().withOptionalParameter("target").ofType(this.stringType);
            operation.withOutput().ofType(this.stringType);
            operation.withOutputAttributes().ofType(this.voidType);
        });
        this.load();
    }

    @Test(expected=IllegalParameterModelDefinitionException.class)
    public void expressionParameterWithFixedValue() {
        this.declare(declarer -> {
            declarer = this.declareBase((ExtensionDeclarer)declarer);
            OperationDeclarer operation = (OperationDeclarer)declarer.withOperation("invalidOperation").describedAs("");
            ((OptionalParameterDeclarer)((OptionalParameterDeclarer)operation.onDefaultParameterGroup().withOptionalParameter("expression").ofType(this.stringType)).withExpressionSupport(ExpressionSupport.REQUIRED)).defaultingTo((Object)"static");
            operation.withOutput().ofType(this.stringType);
            operation.withOutputAttributes().ofType(this.voidType);
        });
        this.load();
    }

    @Test
    public void nullVendor() {
        this.expectIllegalModel("Extension Vendor cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).fromVendor(null));
        this.load();
    }

    @Test
    public void nullCategory() {
        this.expectIllegalModel("Extension Category cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).withCategory(null).fromVendor("SomeVendor").withMinMuleVersion(MIN_MULE_VERSION));
        this.load();
    }

    @Test
    public void nullMinMuleVersion() {
        this.expectIllegalModel("Extension Minimum Mule Version cannot be null");
        this.declare(declarer -> this.declareBase((ExtensionDeclarer)declarer).withMinMuleVersion(null).fromVendor("SomeVendor").withCategory(Category.COMMUNITY));
        this.load();
    }

    private void expectIllegalModel(String messageSubString) {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(CoreMatchers.containsString((String)messageSubString));
    }

    @Test
    public void configlessDescriptor() {
        this.declare(declarer -> declarer.named("noConfigs").onVersion("1.0").fromVendor("MuleSoft").withCategory(Category.COMMUNITY).withXmlDsl(XmlDslModel.builder().build()).withMinMuleVersion(MIN_MULE_VERSION));
        this.load();
    }

    @Test
    public void connectionProviders() {
        Assert.assertThat((Object)this.extensionModel.getConnectionProviders(), (Matcher)Matchers.hasSize((int)1));
        ConnectionProviderModel connectionProvider = (ConnectionProviderModel)this.extensionModel.getConnectionProviders().get(0);
        Assert.assertThat((Object)connectionProvider, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)connectionProvider.getName(), (Matcher)CoreMatchers.is((Object)"connectionProvider"));
        Assert.assertThat((Object)connectionProvider.getDescription(), (Matcher)CoreMatchers.is((Object)"my connection provider"));
        List parameters = connectionProvider.getAllParameterModels();
        this.assertParameter((ParameterModel)parameters.get(0), "username", "Authentication username", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameters.get(1), "password", "Authentication password", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameters.get(2), "reconnection", "When the application is deployed, a connectivity test is performed on all connectors. If set to true, deployment will fail if the test doesn't pass after exhausting the associated reconnection strategy", ExpressionSupport.NOT_SUPPORTED, false, new ReconnectionStrategyTypeBuilder().buildReconnectionConfigType(), ObjectType.class, null);
    }

    @Test
    public void messageSources() {
        Assert.assertThat((Object)this.extensionModel.getSourceModels(), (Matcher)Matchers.hasSize((int)1));
        SourceModel sourceModel = (SourceModel)this.extensionModel.getSourceModels().get(0);
        Assert.assertThat((Object)sourceModel, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)sourceModel.getName(), (Matcher)CoreMatchers.is((Object)"listener"));
        Assert.assertThat((Object)sourceModel.getDescription(), (Matcher)CoreMatchers.is((Object)"Listen requests"));
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)sourceModel.getOutput().getType()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(InputStream.class)));
        Assert.assertThat((Object)JavaTypeUtils.getType((MetadataType)sourceModel.getOutputAttributes().getType()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(Serializable.class)));
        List parameters = sourceModel.getAllParameterModels();
        this.assertByteStreamingStrategyParameter((ParameterModel)parameters.get(0));
        this.assertParameter((ParameterModel)parameters.get(1), "url", "Url to listen on", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameters.get(2), "port", "Port to listen on", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Integer.class), NumberType.class, 8080);
        this.assertParameter((ParameterModel)parameters.get(3), "reconnectionStrategy", "A retry strategy in case of connectivity errors", ExpressionSupport.NOT_SUPPORTED, false, new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType(), UnionType.class, null);
    }

    @Test
    public void objectStreaming() {
        String LIST_TYPES_OPERATION = "LIST_TYPES";
        this.declare(extensionDeclarer -> {
            this.reference.declareOn(extensionDeclarer);
            OperationDeclarer operation = (OperationDeclarer)extensionDeclarer.withOperation("LIST_TYPES").describedAs("List types");
            ((OperationDeclarer)operation.supportsStreaming(true)).withOutput().ofType(this.typeLoader.load(Iterator.class));
            operation.withOutputAttributes().ofType(this.voidType);
            operation.withModelProperty((ModelProperty)new PagedOperationModelProperty());
        });
        ExtensionModel extensionModel = this.load();
        OperationModel operation = (OperationModel)extensionModel.getOperationModel("LIST_TYPES").orElseThrow(IllegalArgumentException::new);
        ParameterModel streamingStrategy = operation.getAllParameterModels().stream().filter(p -> p.getName().equals("streamingStrategy")).findFirst().orElseThrow(IllegalArgumentException::new);
        this.assertObjectStreamingStrategyParameter(streamingStrategy);
    }

    private void assertConsumeOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(2);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("consumer").get())));
        this.assertDataType(operationModel.getOutput().getType(), InputStream.class, BinaryType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"consumer"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Go get them tiger"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)5));
        this.assertByteStreamingStrategyParameter((ParameterModel)parameterModels.get(0));
        this.assertParameter((ParameterModel)parameterModels.get(1), "operation", "The operation to use", ExpressionSupport.SUPPORTED, true, this.stringType, StringType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(2), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), BooleanType.class, true);
        this.assertTargetParameter((ParameterModel)parameterModels.get(3), (ParameterModel)parameterModels.get(4));
    }

    private void assertBroadcastOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(1);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("broadcast").get())));
        this.assertDataType(operationModel.getOutput().getType(), Void.TYPE, VoidType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"broadcast"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"consumes many services"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)3));
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType();
        arrayTypeBuilder.of((TypeBuilder)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType());
        ArrayType arrayType = arrayTypeBuilder.build();
        this.assertParameter((ParameterModel)parameterModels.get(0), "things", "The operation to use", ExpressionSupport.SUPPORTED, true, (MetadataType)arrayType, ArrayType.class, null);
        this.assertParameter((ParameterModel)parameterModels.get(1), "mtomEnabled", "Whether or not use MTOM for attachments", ExpressionSupport.SUPPORTED, false, this.typeLoader.load(Boolean.class), BooleanType.class, true);
        this.assertParameter((ParameterModel)parameterModels.get(2), "callback", "async callback", ExpressionSupport.REQUIRED, true, this.typeLoader.load(OperationModel.class), ObjectType.class, null);
    }

    private void assertTargetParameter(ParameterModel target, ParameterModel targetValue) {
        this.assertParameter(target, "target", "The name of a variable on which the operation's output will be placed", ExpressionSupport.NOT_SUPPORTED, false, this.stringType, StringType.class, null);
        this.assertParameter(targetValue, "targetValue", "An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable", ExpressionSupport.REQUIRED, false, this.targetValue, StringType.class, "#[payload]");
    }

    private void assertByteStreamingStrategyParameter(ParameterModel parameter) {
        this.assertStreamingStrategyParameter(parameter, new StreamingStrategyTypeBuilder().getByteStreamingStrategyType());
    }

    private void assertObjectStreamingStrategyParameter(ParameterModel parameter) {
        this.assertStreamingStrategyParameter(parameter, new StreamingStrategyTypeBuilder().getObjectStreamingStrategyType());
    }

    private void assertStreamingStrategyParameter(ParameterModel parameter, MetadataType type) {
        this.assertParameter(parameter, "streamingStrategy", "Configure if repeatable streams should be used and their behaviour", ExpressionSupport.NOT_SUPPORTED, false, type, UnionType.class, null);
    }

    private void assertArglessOperation(List<OperationModel> operationModels) {
        OperationModel operationModel = operationModels.get(0);
        Assert.assertThat((Object)operationModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(this.extensionModel.getOperationModel("argLess").get())));
        this.assertDataType(operationModel.getOutput().getType(), Integer.class, NumberType.class);
        Assert.assertThat((Object)operationModel.getName(), (Matcher)CoreMatchers.equalTo((Object)"argLess"));
        Assert.assertThat((Object)operationModel.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"has no args"));
        List parameterModels = operationModel.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)2));
        this.assertTargetParameter((ParameterModel)parameterModels.get(0), (ParameterModel)parameterModels.get(1));
    }

    private ExtensionDeclarer declareBase(ExtensionDeclarer extensionDeclarer) {
        this.reference.declareOn(extensionDeclarer);
        return extensionDeclarer;
    }
}

