/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.declaration.type.annotation.DslBaseType;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterRoleAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public final class ExtensionMetadataTypeUtils {
    private ExtensionMetadataTypeUtils() {
    }

    public static Optional<String> getId(MetadataType metadataType) {
        return JavaTypeUtils.getId((MetadataType)metadataType);
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType, ClassLoader classloader) {
        if (!metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            return Optional.empty();
        }
        try {
            return Optional.of(JavaTypeUtils.getType((MetadataType)metadataType, (ClassLoader)classloader));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String getAlias(ObjectFieldType fieldType) {
        return fieldType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(MetadataTypeUtils.getLocalPart((ObjectFieldType)fieldType));
    }

    public static String getAlias(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getAlias(metadataType, "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElseGet(() -> ExtensionMetadataTypeUtils.getType(metadataType).map(type -> NameUtils.getAliasName(defaultName, type.getAnnotation(Alias.class))).orElse(defaultName));
    }

    public static boolean isFinal(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType).map(type -> Modifier.isFinal(type.getModifiers())).orElse(false);
    }

    public static boolean isMap(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.isAssignableFrom(metadataType, Map.class);
    }

    public static boolean isInputStream(MetadataType type) {
        return ExtensionMetadataTypeUtils.isAssignableFrom(type, InputStream.class);
    }

    public static boolean isFlattenedParameterGroup(MetadataType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    private static boolean isAssignableFrom(MetadataType metadataType, Class<?> type) {
        return ExtensionMetadataTypeUtils.getType(metadataType).map(clazz -> type.isAssignableFrom((Class<?>)clazz)).orElse(false);
    }

    public static boolean allowsInlineDefinition(MetadataType type) {
        final Reference supported = new Reference((Object)true);
        type.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                metadataType.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsInlineDefinition).ifPresent(arg_0 -> ((Reference)supported).set(arg_0));
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                Optional paramDsl = objectType.getAnnotation(ParameterDslAnnotation.class);
                Optional typeDsl = objectType.getAnnotation(TypeDslAnnotation.class);
                if (typeDsl.isPresent() && paramDsl.isPresent()) {
                    supported.set((Object)(((TypeDslAnnotation)typeDsl.get()).allowsInlineDefinition() && ((ParameterDslAnnotation)paramDsl.get()).allowsInlineDefinition() ? 1 : 0));
                } else if (typeDsl.isPresent()) {
                    supported.set((Object)((TypeDslAnnotation)typeDsl.get()).allowsInlineDefinition());
                } else {
                    paramDsl.map(ParameterDslAnnotation::allowsInlineDefinition).ifPresent(arg_0 -> ((Reference)supported).set(arg_0));
                }
            }
        });
        return (Boolean)supported.get();
    }

    public static boolean allowsTopLevelDefinition(MetadataType type) {
        return type.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
    }

    public static boolean allowsReferences(MetadataType type) {
        return type.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true);
    }

    public static ExpressionSupport getExpressionSupport(MetadataType metadataType) {
        return metadataType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.SUPPORTED);
    }

    public static ParameterRole getParameterRole(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterRoleAnnotation.class).map(ParameterRoleAnnotation::getRole).orElse(ParameterRole.BEHAVIOUR);
    }

    public static boolean isContent(MetadataType type) {
        return ExtensionModelUtils.isContent(ExtensionMetadataTypeUtils.getParameterRole(type));
    }

    public static Optional<LayoutModel> getLayoutModel(MetadataType metadataType) {
        if (metadataType.getAnnotation(LayoutTypeAnnotation.class).isPresent()) {
            LayoutTypeAnnotation layoutTypeAnnotation = (LayoutTypeAnnotation)metadataType.getAnnotation(LayoutTypeAnnotation.class).get();
            return Optional.of(layoutTypeAnnotation.getLayoutModel());
        }
        return Optional.empty();
    }

    public static boolean isInfrastructure(MetadataType type) {
        return type.getAnnotation(InfrastructureTypeAnnotation.class).isPresent();
    }

    public static boolean acceptsReferences(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true);
    }

    public static boolean isBasic(MetadataType metadataType) {
        final Reference basic = new Reference((Object)false);
        metadataType.accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

            protected void visitBasicType(MetadataType metadataType) {
                basic.set((Object)true);
            }
        });
        return (Boolean)basic.get();
    }

    public static Optional<SubstitutionGroup> getSubstitutionGroup(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeDslAnnotation.class).flatMap(TypeDslAnnotation::getSubstitutionGroup);
    }

    public static Optional<DslBaseType> getBaseType(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeDslAnnotation.class).flatMap(TypeDslAnnotation::getDslBaseType);
    }
}

