/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.loader.validator.ValidatorModelValidator;

@RunWith(value=Parameterized.class)
public class ValidatorModelValidatorTestCase {
    private final boolean childError;
    private final boolean childStereotype;
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OperationModel operationModel;
    private ValidatorModelValidator validator = new ValidatorModelValidator();
    private ProblemsReporter reporter = new ProblemsReporter(this.extensionModel);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Mule error and stereotype", false, false}, {"Child error and mule stereotype", true, false}, {"Child error and Child stereotype", true, true}, {"Mule error and child stereotype", false, true});
    }

    public ValidatorModelValidatorTestCase(String name, boolean childError, boolean childStereotype) {
        this.childError = childError;
        this.childStereotype = childStereotype;
    }

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        StereotypeModel validationStereotype = StereotypeModelBuilder.newStereotype((String)MuleStereotypes.VALIDATOR.getType(), (String)MuleStereotypes.VALIDATOR.getNamespace()).withParent(StereotypeModelBuilder.newStereotype((String)MuleStereotypes.PROCESSOR.getType(), (String)MuleStereotypes.PROCESSOR.getNamespace()).build()).build();
        if (this.childStereotype) {
            validationStereotype = StereotypeModelBuilder.newStereotype((String)"customValidator", (String)"customExtension").withParent(validationStereotype).build();
        }
        Mockito.when((Object)this.operationModel.getStereotype()).thenReturn((Object)validationStereotype);
        ImmutableErrorModel errorModel = new ImmutableErrorModel(MuleErrors.VALIDATION.name(), "MULE", null);
        if (this.childError) {
            errorModel = new ImmutableErrorModel("customValidation", "customExtension", (ErrorModel)errorModel);
        }
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(errorModel));
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn(Mockito.mock(VoidType.class));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
    }

    @Test
    public void valid() {
        this.validator.validate(this.extensionModel, this.reporter);
        Assert.assertThat((Object)this.reporter.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertFail() {
        this.validator.validate(this.extensionModel, this.reporter);
        Assert.assertThat((Object)this.reporter.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nonVoidType() {
        Mockito.when((Object)this.operationModel.getOutput().getType()).thenReturn(Mockito.mock(StringType.class));
        this.assertFail();
    }

    @Test
    public void nonValidationOrphanError() {
        ImmutableErrorModel errorModel = new ImmutableErrorModel("custom", "custom", null);
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(errorModel));
        this.assertFail();
    }

    @Test
    public void nonValidationChildError() {
        ImmutableErrorModel errorModel = new ImmutableErrorModel("custom", "custom", null);
        errorModel = new ImmutableErrorModel("customChild", "custom", (ErrorModel)errorModel);
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(errorModel));
        this.assertFail();
    }
}

