/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.util.concurrent.TimeUnit;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;

public class DynamicConfigExpirationTypeBuilder
extends InfrastructureTypeBuilder {
    public MetadataType buildDynamicConfigExpirationType() {
        ObjectTypeBuilder type = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id("DynamicConfigExpiration").description("Configuration about how should the runtime handle the expiration of dynamic configurations").with((TypeAnnotation)new TypeDslAnnotation(true, false, null, null));
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        type.addField().key("expirationPolicy").value(this.buildExpirationPolicyType()).required(false).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED));
        this.addLongField(type, typeBuilder, "frequency", "A scalar time value for how often should the platform check for expirable dynamic configs", ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getTime()).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED));
        this.addEnumField(type, typeBuilder, "timeUnit", "A time unit that qualifies the frequency attribute", ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getUnit(), TimeUnit.values()).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED));
        return type.build();
    }

    public MetadataType buildExpirationPolicyType() {
        ObjectTypeBuilder type = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().id(ExpirationPolicy.class.getName()).with((TypeAnnotation)new InfrastructureTypeAnnotation()).description("Configures the minimum amount of time that a dynamic configuration instance can remain idle before the runtime considers it eligible for expiration. This does not mean that the platform will expire the instance at the exact moment that it becomes eligible. The runtime will actually purge the instances when it sees it fit.").with((TypeAnnotation)new TypeDslAnnotation(true, false, null, null));
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        this.addLongField(type, typeBuilder, "maxIdleTime", "A scalar time value for the maximum amount of time a dynamic configuration instance should be allowed to be idle before it's considered eligible for expiration", ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getTime()).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED));
        this.addEnumField(type, typeBuilder, "timeUnit", "A time unit that qualifies the maxIdleTime attribute", ExtensionConstants.DYNAMIC_CONFIG_EXPIRATION_FREQUENCY.getUnit(), TimeUnit.values()).with((TypeAnnotation)new ExpressionSupportAnnotation(ExpressionSupport.NOT_SUPPORTED));
        return type.build();
    }
}

