/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.declaration;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public abstract class BaseDeclarationTestCase {
    protected final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);
    protected final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    protected void assertParameter(ParameterDeclaration parameter, String name, String description, ExpressionSupport expressionSupport, boolean required, MetadataType type, Object defaultValue) {
        Assert.assertThat((Object)parameter, (Matcher)CoreMatchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)name));
        Assert.assertThat((Object)parameter.getDescription(), (Matcher)CoreMatchers.is((Object)description));
        Assert.assertThat((Object)parameter.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)expressionSupport));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)required));
        Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)defaultValue));
        Assert.assertThat(parameter.getType().getClass(), (Matcher)CoreMatchers.equalTo(type.getClass()));
        Assert.assertThat((Object)((String)ExtensionMetadataTypeUtils.getId((MetadataType)parameter.getType()).get()), (Matcher)CoreMatchers.equalTo((Object)((String)ExtensionMetadataTypeUtils.getId((MetadataType)type).get())));
    }

    protected void assertDataType(MetadataType type, Class<?> expectedRawType, Class<? extends MetadataType> typeQualifier) {
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(typeQualifier)));
        if (type instanceof NullType || type instanceof VoidType) {
            return;
        }
        Optional typeId = type.getAnnotation(TypeIdAnnotation.class);
        Assert.assertThat((Object)typeId.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        TypeIdAnnotation typeIdAnnotation = (TypeIdAnnotation)typeId.get();
        Assert.assertThat((Object)expectedRawType.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)typeIdAnnotation.getValue())));
    }
}

