/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.metadata;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.metadata.NullQueryMetadataResolver;

public abstract class MetadataResolverUtils {
    private MetadataResolverUtils() {
    }

    public static Optional<String> getCategoryName(MetadataResolverFactory metadataResolverFactory) {
        return MetadataResolverUtils.getDeclaredResolvers(metadataResolverFactory).stream().map(NamedTypeResolver::getCategoryName).filter(name -> !StringUtils.isBlank((CharSequence)name)).findFirst();
    }

    public static List<NamedTypeResolver> getAllResolvers(MetadataResolverFactory metadataResolverFactory) {
        LinkedList<NamedTypeResolver> resolvers = new LinkedList<NamedTypeResolver>();
        resolvers.add((NamedTypeResolver)metadataResolverFactory.getKeyResolver());
        resolvers.add((NamedTypeResolver)metadataResolverFactory.getOutputResolver());
        resolvers.add((NamedTypeResolver)metadataResolverFactory.getOutputAttributesResolver());
        resolvers.add((NamedTypeResolver)metadataResolverFactory.getQueryEntityResolver());
        resolvers.addAll(metadataResolverFactory.getInputResolvers());
        return resolvers;
    }

    public static List<NamedTypeResolver> getDeclaredResolvers(MetadataResolverFactory metadataResolverFactory) {
        return MetadataResolverUtils.getAllResolvers(metadataResolverFactory).stream().filter(r -> !MetadataResolverUtils.isNullResolver(r)).collect(Collectors.toList());
    }

    public static boolean isNullResolver(NamedTypeResolver resolver) {
        return resolver.getClass().equals(NullMetadataResolver.class) || resolver.getClass().equals(org.mule.sdk.api.metadata.NullMetadataResolver.class) || resolver.getClass().equals(NullQueryMetadataResolver.class);
    }
}

