/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.sdk.api.annotation.values.FieldValues;

import java.util.List;

/**
 * Parses the syntactic definition of a {@link FieldValueProviderModel} so that the semantics reflected in it can be extracted in
 * a uniform way, regardless of the actual syntax used by the extension developer.
 *
 * @see ParameterModelParser
 * @since 1.10.0
 */
@NoImplement
public interface FieldValueProviderModelParser extends ValueProviderModelParser {

  /**
   * @return the path of the field whose values are provided within the parameter
   * @see FieldValues#targetSelectors()
   */
  List<String> getTargetSelectors();
}
