/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.sdk.api.values.ValueProvider;

import java.util.Optional;
import java.util.function.Supplier;

/**
 * Contextual information for the {@link ValueProviderFactory} to perform its task.
 *
 * @since 1.10.0
 */
@NoImplement
public interface ValueProviderFactoryContext {

  /**
   * @return the associated {@link ValueProviderModel}.
   */
  ValueProviderModel getModel();

  /**
   * Allows to retrieve parameter values from the {@link ParameterizedModel} container of the {@link ValueProvider}.
   *
   * @return the actual parameterization of the container
   */
  ComponentParameterization<?> getComponentParameterization();

  /**
   * @return a supplier for the configuration, only if the {@link ValueProvider} needs it.
   */
  Optional<Supplier<?>> getConfigurationSupplier();

  /**
   * @return a supplier for the connection, only if the {@link ValueProvider} needs it.
   */
  Optional<Supplier<?>> getConnectionSupplier();

}
