/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.runtime.source;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

import java.util.Optional;

/**
 * Contextual information for the {@link SdkSourceFactory} to perform its task.
 *
 * @since 1.10.0
 */
@NoImplement
public interface SourceFactoryContext {

  /**
   * Allows to retrieve parameter values from the {@link SourceModel}.
   *
   * @return the actual parameterization of the container
   */
  ComponentParameterization<?> getParameterization();

  /**
   * @return the {@link ComponentLocation} of the source component
   */
  ComponentLocation getComponentLocation();

  /**
   * @return an {@link Optional} {@link ConfigurationInstance} if the source requires a configuration
   */
  Optional<ConfigurationInstance> getConfigurationInstance();

  /**
   * @return an {@link Optional} {@link ConnectionProvider} if the source requires a connection
   */
  Optional<ConnectionProvider<?>> getConnectionProvider();

  /**
   * @return the default encoding to be used by the source
   */
  String getDefaultEncoding();

  /**
   * @return the Mule Runtime version
   */
  MuleVersion getRuntimeVersion();
}
