/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.util;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.extension.api.loader.util.InfrastructureTypeUtils;
import org.mule.runtime.extension.api.property.QNameModelProperty;

public class InfrastructureTypeUtilsTestCase {
    @Test
    public void tlsContextFactoryIsMapped() {
        InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType tlsInfraType = InfrastructureTypeUtils.getMetadataTypeBasedInfrastructureType(TlsContextFactory.class);
        MatcherAssert.assertThat((Object)tlsInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)tlsInfraType.getName(), (Matcher)CoreMatchers.is((Object)"tlsContext"));
        MatcherAssert.assertThat((Object)tlsInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void tlsKeyStoreConfigurationIsMapped() {
        InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType keyStoreInfraType = InfrastructureTypeUtils.getMetadataTypeBasedInfrastructureType(TlsContextKeyStoreConfiguration.class);
        MatcherAssert.assertThat((Object)keyStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)keyStoreInfraType.getName(), (Matcher)CoreMatchers.is((Object)"KeyStore"));
        MatcherAssert.assertThat((Object)keyStoreInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)12));
    }

    @Test
    public void tlsTrustStoreConfigurationIsMapped() {
        InfrastructureTypeUtils.MetadataTypeBasedInfrastructureType trustStoreInfraType = InfrastructureTypeUtils.getMetadataTypeBasedInfrastructureType(TlsContextTrustStoreConfiguration.class);
        MatcherAssert.assertThat((Object)trustStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)trustStoreInfraType.getName(), (Matcher)CoreMatchers.is((Object)"TrustStore"));
        MatcherAssert.assertThat((Object)trustStoreInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)13));
    }

    @Test
    public void tlsKeyStoreQNameIsConfigured() {
        InfrastructureTypeUtils.InfrastructureType keyStoreInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"KeyStore");
        MatcherAssert.assertThat((Object)keyStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Optional qName = keyStoreInfraType.getQNameModelProperty();
        MatcherAssert.assertThat((Object)qName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"key-store"));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/tls"));
    }

    @Test
    public void tlsTrustStoreQNameIsConfigured() {
        InfrastructureTypeUtils.InfrastructureType trustStoreInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"TrustStore");
        MatcherAssert.assertThat((Object)trustStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Optional qName = trustStoreInfraType.getQNameModelProperty();
        MatcherAssert.assertThat((Object)qName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"trust-store"));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/tls"));
    }

    @Test
    public void tlsKeyStoreDslConfigurationIsConfigured() {
        InfrastructureTypeUtils.InfrastructureType keyStoreInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"KeyStore");
        MatcherAssert.assertThat((Object)keyStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Optional dslConfig = keyStoreInfraType.getDslConfiguration();
        MatcherAssert.assertThat((Object)dslConfig.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsInlineDefinition(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowTopLevelDefinition(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsReferences(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void tlsTrustStoreDslConfigurationIsConfigured() {
        InfrastructureTypeUtils.InfrastructureType trustStoreInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"TrustStore");
        MatcherAssert.assertThat((Object)trustStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Optional dslConfig = trustStoreInfraType.getDslConfiguration();
        MatcherAssert.assertThat((Object)dslConfig.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsInlineDefinition(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowTopLevelDefinition(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsReferences(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void streamingStrategyInfrastructureTypesAreConfigured() {
        InfrastructureTypeUtils.InfrastructureType fileStoreInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"repeatable-file-store-stream");
        MatcherAssert.assertThat((Object)fileStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)fileStoreInfraType.getQNameModelProperty().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)fileStoreInfraType.getQNameModelProperty().get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"repeatable-file-store-stream"));
        InfrastructureTypeUtils.InfrastructureType inMemoryInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"repeatable-in-memory-stream");
        MatcherAssert.assertThat((Object)inMemoryInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)inMemoryInfraType.getQNameModelProperty().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)inMemoryInfraType.getQNameModelProperty().get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"repeatable-in-memory-stream"));
        InfrastructureTypeUtils.InfrastructureType nonRepeatableInfraType = InfrastructureTypeUtils.getInfrastructureType((String)"non-repeatable-stream");
        MatcherAssert.assertThat((Object)nonRepeatableInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)nonRepeatableInfraType.getQNameModelProperty().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)nonRepeatableInfraType.getQNameModelProperty().get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
    }
}

