/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.loader.parser;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;

import java.util.Set;

/**
 * Parses the syntactical definition of the {@link BackPressureMode}.
 *
 * @since 1.10.0
 */
@NoImplement
public interface BackPressureModeParser {

  /**
   * @return the default {@link BackPressureMode}
   */
  BackPressureMode getDefaultMode();

  /**
   * @return the supported {@link BackPressureMode}s.
   */
  Set<BackPressureMode> getSupportedModes();
}
