/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.dsl;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.test.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class InfrastructureXmlSyntaxDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    public InfrastructureXmlSyntaxDeclarationTestCase() {
        super(ParameterRole.BEHAVIOUR);
    }

    @Test
    public void infrastructureTypeAsFieldDslSyntax() {
        MetadataType type = this.TYPE_LOADER.load(PojoWithInfraField.class);
        DslElementSyntax container = (DslElementSyntax)this.getSyntaxResolver().resolve(type).get();
        DslElementSyntax tls = (DslElementSyntax)container.getContainedElement("tls").get();
        this.assertTlsContextDsl(tls);
        this.assertAttributeName("tls", tls);
    }

    @Issue(value="MULE-19726")
    @Test
    public void infrastructureTypeAsFieldDslSyntaxSupportsTopLevelDeclaration() {
        MetadataType type = this.TYPE_LOADER.load(PojoWithInfraField.class);
        DslElementSyntax container = (DslElementSyntax)this.getSyntaxResolver().resolve(type).get();
        DslElementSyntax tls = (DslElementSyntax)container.getContainedElement("tls").get();
        this.assertTopLevelDeclarationSupportIs(true, tls);
    }

    @Issue(value="MULE-19726")
    @Test
    public void infrastructureTypeDslSyntaxSupportsTopLevelDeclaration() {
        MetadataType type = this.TYPE_LOADER.load(TlsContextFactory.class);
        DslElementSyntax result = (DslElementSyntax)this.getSyntaxResolver().resolve(type).get();
        this.assertTopLevelDeclarationSupportIs(true, result);
    }

    @Test
    public void infrastructureTypeDslSyntax() {
        MetadataType type = this.TYPE_LOADER.load(TlsContextFactory.class);
        this.assertTlsContextDsl((DslElementSyntax)this.getSyntaxResolver().resolve(type).get());
    }

    @Test
    public void infrastructureParameterDslSyntax() {
        Assume.assumeThat((Object)ExtensionModelUtils.isContent((ParameterModel)this.parameterModel), (Matcher)CoreMatchers.is((Object)false));
        InfrastructureParameterModelProperty infraMP = new InfrastructureParameterModelProperty(1);
        QNameModelProperty qNameMP = new QNameModelProperty(new QName("http://www.mulesoft.org/schema/mule/tls", "context", "tls"));
        Mockito.when((Object)this.parameterModel.getModelProperties()).thenReturn(new HashSet<ModelProperty>(Arrays.asList(infraMP, qNameMP)));
        Mockito.when((Object)this.parameterModel.getModelProperty(InfrastructureParameterModelProperty.class)).thenReturn(Optional.of(infraMP));
        Mockito.when((Object)this.parameterModel.getModelProperty(QNameModelProperty.class)).thenReturn(Optional.of(qNameMP));
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(TlsContextFactory.class));
        DslElementSyntax result = this.getSyntaxResolver().resolve(this.parameterModel);
        this.assertTlsContextDsl(result);
        this.assertAttributeName("myCamelCaseName", result);
    }

    private void assertTlsContextDsl(DslElementSyntax tls) {
        this.assertElementName("context", tls);
        this.assertElementPrefix("tls", tls);
        this.assertParameterChildElementDeclaration(true, tls);
        this.assertIsWrappedElement(false, tls);
        this.assertAttributeOnly("enabledProtocols", tls);
        this.assertAttributeOnly("enabledCipherSuites", tls);
        this.assertChildOnly("key-store", "key-store", tls);
        this.assertChildOnly("trust-store", "trust-store", tls);
        DslElementSyntax trustStore = (DslElementSyntax)tls.getContainedElement("trust-store").get();
        this.assertAttributeOnly("password", trustStore);
        this.assertAttributeOnly("path", trustStore);
        this.assertAttributeOnly("insecure", trustStore);
        this.assertAttributeOnly("algorithm", trustStore);
        DslElementSyntax keyStore = (DslElementSyntax)tls.getContainedElement("key-store").get();
        this.assertAttributeOnly("path", keyStore);
        this.assertAttributeOnly("alias", keyStore);
        this.assertAttributeOnly("keyPassword", keyStore);
        this.assertAttributeOnly("password", keyStore);
        this.assertAttributeOnly("algorithm", keyStore);
    }

    private void assertChildOnly(String name, String elementName, DslElementSyntax parent) {
        DslElementSyntax child = (DslElementSyntax)parent.getContainedElement(name).get();
        this.assertElementName(elementName, child);
        this.assertElementPrefix(parent.getPrefix(), child);
        this.assertAttributeDeclaration(false, child);
        this.assertParameterChildElementDeclaration(true, child);
        this.assertElementName(elementName, child);
    }

    private void assertAttributeOnly(String name, DslElementSyntax parent) {
        DslElementSyntax child = (DslElementSyntax)parent.getContainedElement(name).get();
        this.assertAttributeDeclaration(true, child);
        this.assertAttributeName(name, child);
        this.assertParameterChildElementDeclaration(false, child);
    }

    public static final class PojoWithInfraField {
        @Parameter
        private TlsContextFactory tls;

        public TlsContextFactory getTls() {
            return this.tls;
        }

        public void setTls(TlsContextFactory tls) {
            this.tls = tls;
        }
    }
}

