/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime.parameters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

@RunWith(value=Parameterized.class)
public class OutbountCorrelationStrategyTestCase {
    private static final String EVENT_ID = "eventId";
    private static final String DEFAULT_CORRELATION_ID = "defaultCorrelationId";
    private static final String CUSTOM_CORRELATION_ID = "customCorrelationId";
    private final CorrelationInfo correlationInfo;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"correlation enabled", OutbountCorrelationStrategyTestCase.buildCorrelationInfo(true)}, {"correlation disabled", OutbountCorrelationStrategyTestCase.buildCorrelationInfo(false)});
    }

    private static CorrelationInfo buildCorrelationInfo(boolean correlationEnabled) {
        CorrelationInfo info = (CorrelationInfo)Mockito.mock(CorrelationInfo.class);
        Mockito.when((Object)info.isOutboundCorrelationEnabled()).thenReturn((Object)correlationEnabled);
        Mockito.when((Object)info.getEventId()).thenReturn((Object)EVENT_ID);
        Mockito.when((Object)info.getCorrelationId()).thenReturn((Object)DEFAULT_CORRELATION_ID);
        return info;
    }

    public OutbountCorrelationStrategyTestCase(String name, CorrelationInfo correlationInfo) {
        this.correlationInfo = correlationInfo;
    }

    @Test
    public void alwaysDefault() {
        this.assertCorrelation(OutboundCorrelationStrategy.ALWAYS.getOutboundCorrelationId(this.correlationInfo, null), DEFAULT_CORRELATION_ID);
    }

    @Test
    public void alwaysCustom() {
        this.assertCorrelation(OutboundCorrelationStrategy.ALWAYS.getOutboundCorrelationId(this.correlationInfo, CUSTOM_CORRELATION_ID), CUSTOM_CORRELATION_ID);
    }

    @Test
    public void autoDefault() {
        Optional correlationId = OutboundCorrelationStrategy.AUTO.getOutboundCorrelationId(this.correlationInfo, null);
        if (this.correlationInfo.isOutboundCorrelationEnabled()) {
            this.assertCorrelation(correlationId, DEFAULT_CORRELATION_ID);
        } else {
            Assert.assertThat((Object)correlationId.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void autoCustom() {
        Optional correlationId = OutboundCorrelationStrategy.AUTO.getOutboundCorrelationId(this.correlationInfo, CUSTOM_CORRELATION_ID);
        if (this.correlationInfo.isOutboundCorrelationEnabled()) {
            this.assertCorrelation(correlationId, CUSTOM_CORRELATION_ID);
        } else {
            Assert.assertThat((Object)correlationId.isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void neverDefault() {
        Assert.assertThat((Object)OutboundCorrelationStrategy.NEVER.getOutboundCorrelationId(this.correlationInfo, null).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void neverCustom() {
        Assert.assertThat((Object)OutboundCorrelationStrategy.NEVER.getOutboundCorrelationId(this.correlationInfo, CUSTOM_CORRELATION_ID).isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void assertCorrelation(Optional<String> optional, String expected) {
        String actual = optional.orElse(null);
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actual, (Matcher)CoreMatchers.is((Object)expected));
    }
}

