/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.dsl.xml.TypeDsl;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterResolverTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

public class ExtensionObjectTypeHandler
extends ObjectHandler {
    private final ParameterResolverTypeAnnotation parameterResolverTypeAnnotation = new ParameterResolverTypeAnnotation();
    private final LiteralTypeAnnotation literalTypeAnnotation = new LiteralTypeAnnotation();
    private final TypedValueTypeAnnotation typedValueTypeAnnotation = new TypedValueTypeAnnotation();
    private final Map<Class<?>, ParsingContext> wrappedTypesContexts = ImmutableMap.builder().put(ParameterResolver.class, (Object)new ParsingContext()).put(TypedValue.class, (Object)new ParsingContext()).put(Literal.class, (Object)new ParsingContext()).build();

    public ExtensionObjectTypeHandler(ObjectFieldHandler fieldHandler) {
        super(fieldHandler);
    }

    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder baseTypeBuilder) {
        BaseTypeBuilder typeBuilder = baseTypeBuilder;
        Class<?> currentClass = clazz;
        if (ParameterResolver.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, this.wrappedTypesContexts.get(ParameterResolver.class), baseTypeBuilder, this.parameterResolverTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else if (TypedValue.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, this.wrappedTypesContexts.get(TypedValue.class), baseTypeBuilder, this.typedValueTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else if (Literal.class.isAssignableFrom(clazz)) {
            this.handleGenericType(clazz, genericTypes, typeHandlerManager, this.wrappedTypesContexts.get(Literal.class), baseTypeBuilder, this.literalTypeAnnotation);
            currentClass = this.getGenericClass(genericTypes, 0);
        } else {
            typeBuilder = super.handleClass(currentClass, genericTypes, typeHandlerManager, context, baseTypeBuilder);
        }
        if (typeBuilder != null && typeBuilder instanceof WithAnnotation) {
            Alias alias;
            TypeDsl typeDsl;
            WithAnnotation annotatedBuilder = (WithAnnotation)typeBuilder;
            if (currentClass.isAnnotationPresent(Extensible.class)) {
                annotatedBuilder.with((TypeAnnotation)new ExtensibleTypeAnnotation());
            }
            if ((typeDsl = currentClass.getAnnotation(TypeDsl.class)) != null) {
                annotatedBuilder.with((TypeAnnotation)new TypeDslAnnotation(typeDsl.allowInlineDefinition(), typeDsl.allowTopLevelDefinition(), typeDsl.substitutionGroup(), typeDsl.baseType()));
            }
            annotatedBuilder.with((TypeAnnotation)new TypeAliasAnnotation((alias = currentClass.getAnnotation(Alias.class)) != null ? alias.value() : currentClass.getSimpleName()));
            Stereotype stereotype = currentClass.getAnnotation(Stereotype.class);
            if (stereotype != null) {
                annotatedBuilder.with((TypeAnnotation)StereotypeTypeAnnotation.fromDefinitions(Collections.singletonList(stereotype.value())));
            }
        }
        return typeBuilder;
    }

    private Class<?> getGenericClass(List<Type> genericTypes, int position) {
        Type type = genericTypes.get(position);
        return type instanceof Class ? (Class)type : Object.class;
    }

    private void handleGenericType(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder, TypeAnnotation annotation) {
        Preconditions.checkArgument((!genericTypes.isEmpty() ? 1 : 0) != 0, (String)String.format("Type %s doesn't have the required generic type", clazz));
        TypeBuilder handle = typeHandlerManager.handle(genericTypes.get(0), context, typeBuilder);
        if (handle instanceof WithAnnotation) {
            ((WithAnnotation)handle).with(annotation);
        }
    }
}

