/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ExtensionModelUtilsTestCase {
    @Test
    public void componentWithImplicitAssociatedConfig() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        OperationModel ope = (OperationModel)Mockito.mock(OperationModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ConnectionProviderModel cp = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)cp.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)c.getOperationModels()).thenReturn(Collections.singletonList(ope));
        Mockito.when((Object)c.getConnectionProviders()).thenReturn(Collections.singletonList(cp));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)ope), (Matcher)Is.is((Object)true));
    }

    @Test
    public void componentWithConfigWithoutConnectionProviders() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        SourceModel source = (SourceModel)Mockito.mock(SourceModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)c.getSourceModels()).thenReturn(Collections.singletonList(source));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)source), (Matcher)Is.is((Object)true));
    }

    @Test
    public void componentWithImplicitConfigWithNonImplicitConnectionProviders() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        OperationModel ope = (OperationModel)Mockito.mock(OperationModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ConnectionProviderModel cp = (ConnectionProviderModel)Mockito.mock(ConnectionProviderModel.class);
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)cp.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)c.getOperationModels()).thenReturn(Collections.singletonList(ope));
        Mockito.when((Object)c.getConnectionProviders()).thenReturn(Collections.singletonList(cp));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)ope), (Matcher)Is.is((Object)false));
    }

    @Test
    public void componentWithNoImplicitConfigs() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        SourceModel source = (SourceModel)Mockito.mock(SourceModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)c.getSourceModels()).thenReturn(Collections.singletonList(source));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)source), (Matcher)Is.is((Object)false));
    }

    @Test
    public void componentWithImplicitConfigs() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        SourceModel source = (SourceModel)Mockito.mock(SourceModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)c.getSourceModels()).thenReturn(Collections.singletonList(source));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)source), (Matcher)Is.is((Object)true));
    }

    @Test
    public void componentWithForcedNoImplicit() {
        ExtensionModel em = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        SourceModel source = (SourceModel)Mockito.mock(SourceModel.class);
        ConfigurationModel c = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        Mockito.when((Object)c.getModelProperty(NoImplicitModelProperty.class)).thenReturn(Optional.of(new NoImplicitModelProperty()));
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.isRequired()).thenReturn((Object)false);
        Mockito.when((Object)c.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        Mockito.when((Object)c.getSourceModels()).thenReturn(Collections.singletonList(source));
        Mockito.when((Object)em.getConfigurationModels()).thenReturn(Collections.singletonList(c));
        Assert.assertThat((Object)ExtensionModelUtils.componentHasAnImplicitConfiguration((ExtensionModel)em, (ComponentModel)source), (Matcher)Is.is((Object)false));
    }
}

