/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.extension.internal.loader.enricher.TransactionalDeclarationEnricher;

@RunWith(value=MockitoJUnitRunner.class)
public class TransactionalDeclarationEnricherTestCase {
    private static final String TRANSACTIONAL_OPERATION = "transactionalOperation";
    private static final String NOT_TRANSACTIONAL_OPERATION = "notConnectedOperation";
    private static final String TRANSACTIONAL_SOURCE = "transactionalSource";
    private final NullModelProperty nullModelProperty = new NullModelProperty();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    private OperationDeclaration transactionalOperation;
    private OperationDeclaration notTransactionalOperation;
    private SourceDeclaration transactionalSource;
    private SourceDeclaration transactionalSourceWithTxParameter;
    private DeclarationEnricher enricher = new TransactionalDeclarationEnricher();
    private MetadataType operationTransactionalActionType;
    private MetadataType sourceTransactionalActionType;
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void before() throws Exception {
        this.operationTransactionalActionType = this.typeLoader.load(OperationTransactionalAction.class);
        this.sourceTransactionalActionType = this.typeLoader.load(SourceTransactionalAction.class);
        this.transactionalOperation = (OperationDeclaration)Mockito.spy((Object)((OperationDeclarer)new ExtensionDeclarer().withOperation(TRANSACTIONAL_OPERATION).transactional(true)).getDeclaration());
        this.notTransactionalOperation = (OperationDeclaration)Mockito.spy((Object)((OperationDeclarer)new ExtensionDeclarer().withOperation(NOT_TRANSACTIONAL_OPERATION).transactional(false)).getDeclaration());
        this.transactionalSource = (SourceDeclaration)Mockito.spy((Object)((SourceDeclarer)new ExtensionDeclarer().withMessageSource(TRANSACTIONAL_SOURCE).transactional(true)).getDeclaration());
        SourceDeclarer transactional = (SourceDeclarer)new ExtensionDeclarer().withMessageSource(TRANSACTIONAL_SOURCE).transactional(true);
        transactional.onDefaultParameterGroup().withRequiredParameter("transactionalAction").withModelProperty((ModelProperty)this.nullModelProperty).ofType(this.sourceTransactionalActionType);
        this.transactionalSourceWithTxParameter = (SourceDeclaration)Mockito.spy((Object)transactional.getDeclaration());
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.transactionalOperation, this.notTransactionalOperation));
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Arrays.asList(this.transactionalSource));
    }

    @Test
    public void enrichOperation() throws Exception {
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration transactionParameter = this.getTransactionActionParameter((ComponentDeclaration)this.transactionalOperation).orElse(null);
        this.assertTxParameter(transactionParameter, this.operationTransactionalActionType, OperationTransactionalAction.JOIN_IF_POSSIBLE, "The type of joining action that operations can take regarding transactions.");
    }

    @Test
    public void enrichSource() throws Exception {
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration transactionParameter = this.getTransactionActionParameter((ComponentDeclaration)this.transactionalSource).orElse(null);
        this.assertTxParameter(transactionParameter, this.sourceTransactionalActionType, SourceTransactionalAction.NONE, "The type of beginning action that sources can take regarding transactions.");
    }

    @Test
    public void enrichExistingTransactionalActionParameterIfExist() throws Exception {
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Arrays.asList(this.transactionalSourceWithTxParameter));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration transactionParameter = this.getTransactionActionParameter((ComponentDeclaration)this.transactionalSourceWithTxParameter).orElse(null);
        this.assertTxParameter(transactionParameter, this.sourceTransactionalActionType, SourceTransactionalAction.NONE, "The type of beginning action that sources can take regarding transactions.");
        Assert.assertThat((Object)transactionParameter.getModelProperty(NullModelProperty.class), (Matcher)Matchers.is(Optional.of(this.nullModelProperty)));
    }

    @Test
    public void enrichOnlyOnceWhenFlyweight() throws Exception {
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.transactionalOperation, this.transactionalOperation, this.notTransactionalOperation));
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat((Object)this.getTransactionActionParameter((ComponentDeclaration)this.transactionalOperation).isPresent(), (Matcher)Matchers.is((Object)true));
    }

    private void assertTxParameter(ParameterDeclaration transactionParameter, MetadataType type, Object defaultValue, String description) {
        Assert.assertThat((Object)transactionParameter, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)transactionParameter.getType(), (Matcher)Matchers.equalTo((Object)type));
        Assert.assertThat((Object)transactionParameter.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        Assert.assertThat((Object)transactionParameter.isRequired(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)transactionParameter.getDefaultValue(), (Matcher)Matchers.is((Object)defaultValue));
        Assert.assertThat((Object)transactionParameter.getDescription(), (Matcher)Matchers.is((Object)description));
        Assert.assertThat(transactionParameter.getLayoutModel().getTabName().get(), (Matcher)Matchers.is((Object)"Advanced"));
    }

    private Optional<ParameterDeclaration> getTransactionActionParameter(ComponentDeclaration declaration) {
        List txParameters = declaration.getParameterGroup("General").getParameters().stream().filter(p -> p.getName().equals("transactionalAction")).collect(Collectors.toList());
        Assert.assertThat(txParameters, (Matcher)Matchers.anyOf((Matcher)Matchers.hasSize((int)1), (Matcher)Matchers.hasSize((int)0)));
        return txParameters.isEmpty() ? Optional.empty() : Optional.of(txParameters.get(0));
    }

    private class NullModelProperty
    implements ModelProperty {
        private NullModelProperty() {
        }

        public String getName() {
            return null;
        }

        public boolean isPublic() {
            return false;
        }
    }
}

