/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.internal.loader.enricher.OAuthDeclarationEnricher;

public class OAuthDeclarationEnricherTestCase {
    private ExtensionLoadingContext extensionLoadingContext;
    private ExtensionDeclaration extensionDeclaration;
    private ExtensionDeclarer extensionDeclarer;
    private ConnectionProviderDeclaration connectionProviderDeclaration;
    private ParameterGroupDeclaration oauthAuthorizationCodeGroupDeclaration;
    private ParameterGroupDeclaration oauthCallbackConfigGroupDeclaration;
    private ParameterGroupDeclaration oauthStoreConfigGroupDeclaration;
    private ParameterGroupDeclaration oauthClientCredentialsGroupDeclaration;
    private OAuthDeclarationEnricher enricher;

    @Before
    public void before() {
        this.extensionLoadingContext = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        this.extensionDeclaration = (ExtensionDeclaration)Mockito.mock(ExtensionDeclaration.class);
        this.extensionDeclarer = (ExtensionDeclarer)Mockito.mock(ExtensionDeclarer.class);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        this.connectionProviderDeclaration = (ConnectionProviderDeclaration)Mockito.mock(ConnectionProviderDeclaration.class);
        this.oauthAuthorizationCodeGroupDeclaration = new ParameterGroupDeclaration("oauthAuthorizationCode");
        Mockito.when((Object)this.connectionProviderDeclaration.getParameterGroup("oauthAuthorizationCode")).thenReturn((Object)this.oauthAuthorizationCodeGroupDeclaration);
        this.oauthCallbackConfigGroupDeclaration = new ParameterGroupDeclaration("oauthCallbackConfig");
        Mockito.when((Object)this.connectionProviderDeclaration.getParameterGroup("oauthCallbackConfig")).thenReturn((Object)this.oauthCallbackConfigGroupDeclaration);
        this.oauthStoreConfigGroupDeclaration = new ParameterGroupDeclaration("oauthStoreConfig");
        Mockito.when((Object)this.connectionProviderDeclaration.getParameterGroup("oauthStoreConfig")).thenReturn((Object)this.oauthStoreConfigGroupDeclaration);
        this.oauthClientCredentialsGroupDeclaration = new ParameterGroupDeclaration("oauthClientCredentials");
        Mockito.when((Object)this.connectionProviderDeclaration.getParameterGroup("oauthClientCredentials")).thenReturn((Object)this.oauthClientCredentialsGroupDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderDeclaration));
        this.enricher = new OAuthDeclarationEnricher();
    }

    @Test
    @Issue(value="MULE-18528")
    public void stereotypesForAuthorizationCode() {
        Mockito.when((Object)this.connectionProviderDeclaration.getModelProperty(OAuthModelProperty.class)).thenReturn(Optional.of(new OAuthModelProperty(Arrays.asList(new AuthorizationCodeGrantType("http://accessToken", "http://authorizationUrl", "#[accessToken]", ".*", "#[refreshToken]", "scope")))));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration listenerConfigParam = this.oauthCallbackConfigGroupDeclaration.getParameters().stream().filter(p -> p.getName().equals("listenerConfig")).findFirst().get();
        Assert.assertThat((Object)listenerConfigParam.getAllowedStereotypeModels(), (Matcher)IsCollectionContaining.hasItem((Object)StereotypeModelBuilder.newStereotype((String)"LISTENER_CONFIG", (String)"HTTP").withParent(MuleStereotypes.CONFIG).build()));
        ParameterDeclaration beforeFlowParam = this.oauthAuthorizationCodeGroupDeclaration.getParameters().stream().filter(p -> p.getName().equals("before")).findFirst().get();
        Assert.assertThat((Object)beforeFlowParam.getAllowedStereotypeModels(), (Matcher)IsCollectionContaining.hasItem((Object)MuleStereotypes.FLOW));
        ParameterDeclaration afterFlowParam = this.oauthAuthorizationCodeGroupDeclaration.getParameters().stream().filter(p -> p.getName().equals("after")).findFirst().get();
        Assert.assertThat((Object)afterFlowParam.getAllowedStereotypeModels(), (Matcher)IsCollectionContaining.hasItem((Object)MuleStereotypes.FLOW));
    }

    @Test
    public void stereotypesForObjectStore() {
        Mockito.when((Object)this.connectionProviderDeclaration.getModelProperty(OAuthModelProperty.class)).thenReturn(Optional.of(new OAuthModelProperty(Arrays.asList(new ClientCredentialsGrantType("http://accessToken", "#[accessToken]", ".*", "scope", CredentialsPlacement.BODY)))));
        this.enricher.enrich(this.extensionLoadingContext);
        ParameterDeclaration afterFlowParam = this.oauthStoreConfigGroupDeclaration.getParameters().stream().filter(p -> p.getName().equals("objectStore")).findFirst().get();
        Assert.assertThat((Object)afterFlowParam.getAllowedStereotypeModels(), (Matcher)IsCollectionContaining.hasItem((Object)MuleStereotypes.OBJECT_STORE));
    }
}

