/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;

@RunWith(value=Parameterized.class)
public class NoWrapperComponentXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    private NestedComponentModel grandParentComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel parentComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel child1ComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel child2ComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel anotherGrandParentComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel anotherParentComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel anotherChildComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);

    public NoWrapperComponentXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Before
    public void setup() {
        ArrayList<NestedComponentModel> operationNestedComponents = new ArrayList<NestedComponentModel>();
        operationNestedComponents.add(this.grandParentComponentModel);
        operationNestedComponents.add(this.anotherGrandParentComponentModel);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operation});
        Mockito.when((Object)this.operation.getNestedComponents()).thenReturn(operationNestedComponents);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        this.mockNestedComponent("grand-parent", this.grandParentComponentModel, 0, 10, this.parentComponentModel);
        this.mockNestedComponent("parent", this.parentComponentModel, 0, 10, this.child1ComponentModel, this.child2ComponentModel);
        this.mockNestedComponent("child1", this.child1ComponentModel, 0, 10, new NestedComponentModel[0]);
        this.mockNestedComponent("child2", this.child2ComponentModel, 0, 10, new NestedComponentModel[0]);
        this.mockNestedComponent("another-grand-parent", this.anotherGrandParentComponentModel, 0, 10, this.anotherParentComponentModel);
        this.mockNestedComponent("another-parent", this.anotherParentComponentModel, 0, 10, this.anotherChildComponentModel);
        this.mockNestedComponent("another-child", this.anotherChildComponentModel, 0, 10, new NestedComponentModel[0]);
    }

    @Test
    public void testNestedComponentWithNoWrapperModelProperty() {
        Mockito.when((Object)this.parentComponentModel.getModelProperty(NoWrapperModelProperty.class)).thenReturn(Optional.of(NoWrapperModelProperty.INSTANCE));
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        List grandparents = result.getChilds().stream().map(DslElementSyntax::getElementName).collect(Collectors.toList());
        MatcherAssert.assertThat(grandparents, (Matcher)Matchers.hasItems((Object[])new String[]{this.grandParentComponentModel.getName(), this.anotherGrandParentComponentModel.getName()}));
        DslElementSyntax grandParentDsl = (DslElementSyntax)result.getChild(this.grandParentComponentModel.getName()).get();
        DslElementSyntax anotherGrandParentDsl = (DslElementSyntax)result.getChild(this.anotherGrandParentComponentModel.getName()).get();
        MatcherAssert.assertThat((Object)grandParentDsl.getChild(this.parentComponentModel.getName()).isPresent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)grandParentDsl.getChild(this.child1ComponentModel.getName()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)grandParentDsl.getChild(this.child2ComponentModel.getName()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)anotherGrandParentDsl.getChild(this.anotherParentComponentModel.getName()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)anotherGrandParentDsl.getChild(this.anotherParentComponentModel.getName()).get()).getChild(this.anotherChildComponentModel.getName()).isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void mockNestedComponent(String componentName, NestedComponentModel nestedComponentModelMock, int minOccurs, Integer maxOccurs, NestedComponentModel ... children) {
        Mockito.when((Object)nestedComponentModelMock.getName()).thenReturn((Object)componentName);
        Mockito.when((Object)nestedComponentModelMock.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)nestedComponentModelMock.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)nestedComponentModelMock.getMinOccurs()).thenReturn((Object)minOccurs);
        Mockito.when((Object)nestedComponentModelMock.getMaxOccurs()).thenReturn(Optional.ofNullable(maxOccurs));
        Mockito.when((Object)nestedComponentModelMock.isRequired()).thenReturn((Object)(minOccurs != 0 ? 1 : 0));
        List<NestedComponentModel> nestedComponentModels = Arrays.asList(children);
        Mockito.when((Object)nestedComponentModelMock.getNestedComponents()).thenReturn(nestedComponentModels);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{nestedComponentModelMock});
    }
}

