/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.extension.api.dsl.BaseXmlDeclarationTestCase;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

@RunWith(value=Parameterized.class)
public class ComposableXmlDeclarationTestCase
extends BaseXmlDeclarationTestCase {
    private static final String INLINE_PARAMETER_NAME = "inlineParameterName";
    private static final String PARAMETER_GROUP_SHOW_IN_DSL_NAME = "InlineParameterGroup";
    private NestedComponentModel firstNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel secondNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel thirdNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);
    private NestedComponentModel innerNestedComponentModel = (NestedComponentModel)Mockito.mock(NestedComponentModel.class);

    public ComposableXmlDeclarationTestCase(ParameterRole role) {
        super(role);
    }

    @Before
    public void mockComposableModels() {
        ArrayList<NestedComponentModel> operationNestedComponents = new ArrayList<NestedComponentModel>();
        operationNestedComponents.add(this.firstNestedComponentModel);
        operationNestedComponents.add(this.secondNestedComponentModel);
        operationNestedComponents.add(this.thirdNestedComponentModel);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operation});
        Mockito.when((Object)this.operation.getNestedComponents()).thenReturn(operationNestedComponents);
        Mockito.when((Object)this.parameterModel.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        this.mockFirstNestedComponent();
        this.mockSecondNestedComponent();
        this.mockThirdNestedComponent();
        this.mockInnerNesterComponent();
    }

    private void mockFirstNestedComponent() {
        this.mockNestedComponent("first-nested", this.firstNestedComponentModel, 0, 200);
        ArrayList<NestedComponentModel> innerNestedComponents = new ArrayList<NestedComponentModel>();
        innerNestedComponents.add(this.innerNestedComponentModel);
        Mockito.when((Object)this.firstNestedComponentModel.getNestedComponents()).thenReturn(innerNestedComponents);
    }

    private void mockSecondNestedComponent() {
        this.mockNestedComponent("second-nested", this.secondNestedComponentModel, 3, null);
    }

    private void mockThirdNestedComponent() {
        this.mockNestedComponent("third-nested", this.thirdNestedComponentModel, 0, null);
    }

    private void mockInnerNesterComponent() {
        this.mockNestedComponent("inner-nested", this.innerNestedComponentModel, 2, 5);
        ParameterModel parameterModelMock = (ParameterModel)Mockito.mock(ParameterModel.class);
        ParameterGroupModel parameterGroupModelMock = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)parameterModelMock.getName()).thenReturn((Object)INLINE_PARAMETER_NAME);
        Mockito.when((Object)parameterModelMock.getType()).thenReturn((Object)this.TYPE_LOADER.load(String.class));
        Mockito.when((Object)parameterModelMock.getExpressionSupport()).thenReturn((Object)ExpressionSupport.SUPPORTED);
        Mockito.when((Object)parameterModelMock.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)parameterModelMock.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)parameterModelMock.getLayoutModel()).thenReturn(Optional.empty());
        Mockito.when((Object)parameterModelMock.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        Mockito.when((Object)parameterGroupModelMock.getName()).thenReturn((Object)PARAMETER_GROUP_SHOW_IN_DSL_NAME);
        Mockito.when((Object)parameterGroupModelMock.isShowInDsl()).thenReturn((Object)true);
        Mockito.when((Object)parameterGroupModelMock.getParameterModels()).thenReturn(Arrays.asList(parameterModelMock));
        Mockito.when((Object)this.innerNestedComponentModel.getParameterGroupModels()).thenReturn(Arrays.asList(parameterGroupModelMock));
        Mockito.when((Object)this.innerNestedComponentModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModelMock));
    }

    private void mockNestedComponent(String componentName, NestedComponentModel nestedComponentModelMock, int minOccurs, Integer maxOccurs) {
        Mockito.when((Object)nestedComponentModelMock.getName()).thenReturn((Object)componentName);
        Mockito.when((Object)nestedComponentModelMock.getParameterGroupModels()).thenReturn(Arrays.asList(this.parameterGroupModel));
        Mockito.when((Object)nestedComponentModelMock.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)nestedComponentModelMock.getMinOccurs()).thenReturn((Object)minOccurs);
        Mockito.when((Object)nestedComponentModelMock.getMaxOccurs()).thenReturn(Optional.ofNullable(maxOccurs));
        Mockito.when((Object)nestedComponentModelMock.isRequired()).thenReturn((Object)(minOccurs != 0 ? 1 : 0));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{nestedComponentModelMock});
    }

    @Test
    public void nestedComposableComponents() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        List childNames = result.getChilds().stream().map(DslElementSyntax::getElementName).collect(Collectors.toList());
        MatcherAssert.assertThat(childNames, (Matcher)Matchers.hasItems((Object[])new String[]{this.firstNestedComponentModel.getName(), this.secondNestedComponentModel.getName(), this.thirdNestedComponentModel.getName()}));
    }

    @Test
    public void innerNestedComposableComponent() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Optional innerNested = ((DslElementSyntax)result.getChild(this.firstNestedComponentModel.getName()).get()).getChild(this.innerNestedComponentModel.getName());
        MatcherAssert.assertThat((Object)innerNested.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)innerNested.get()).getElementName(), (Matcher)CoreMatchers.is((Object)this.innerNestedComponentModel.getName()));
    }

    @Test
    public void nestedComposableComponentParameters() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        ArrayList firstNestedComponentChildren = new ArrayList();
        firstNestedComponentChildren.add(result.getChild(this.firstNestedComponentModel.getName()).get());
        firstNestedComponentChildren.add(result.getChild(this.secondNestedComponentModel.getName()).get());
        firstNestedComponentChildren.add(result.getChild(this.thirdNestedComponentModel.getName()).get());
        for (DslElementSyntax child : firstNestedComponentChildren) {
            Optional parameterDslSyntax;
            if (this.parameterModel.getRole().equals((Object)ParameterRole.BEHAVIOUR)) {
                parameterDslSyntax = child.getAttribute(this.parameterModel.getName());
                MatcherAssert.assertThat((Object)parameterDslSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)((DslElementSyntax)parameterDslSyntax.get()).getAttributeName(), (Matcher)CoreMatchers.is((Object)this.parameterModel.getName()));
                continue;
            }
            parameterDslSyntax = child.getChild(this.parameterModel.getName());
            MatcherAssert.assertThat((Object)parameterDslSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)((DslElementSyntax)parameterDslSyntax.get()).getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)this.parameterModel.getName())));
        }
    }

    @Test
    public void innerNestedCompasableComponentInlineParameter() {
        DslElementSyntax result = this.getSyntaxResolver().resolve((NamedObject)this.operation);
        Optional firstNestedComponentModelSyntax = result.getChild(this.firstNestedComponentModel.getName());
        MatcherAssert.assertThat((Object)firstNestedComponentModelSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Optional innerNestedComponentModelSyntax = ((DslElementSyntax)firstNestedComponentModelSyntax.get()).getChild(this.innerNestedComponentModel.getName());
        MatcherAssert.assertThat((Object)innerNestedComponentModelSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Optional inlineParameterGroupSyntax = ((DslElementSyntax)innerNestedComponentModelSyntax.get()).getChild(PARAMETER_GROUP_SHOW_IN_DSL_NAME);
        MatcherAssert.assertThat((Object)inlineParameterGroupSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Optional parameterInInlineGroupSyntax = ((DslElementSyntax)inlineParameterGroupSyntax.get()).getAttribute(INLINE_PARAMETER_NAME);
        MatcherAssert.assertThat((Object)parameterInInlineGroupSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)parameterInInlineGroupSyntax.get()).getAttributeName(), (Matcher)CoreMatchers.is((Object)INLINE_PARAMETER_NAME));
    }
}

