/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.runtime;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class PollingSourceTestCase {
    public static final String TEST_FLOW_NAME = "myFlow";
    public static final String EXPECTED_WATERMARK_OS = "_pollingSource_myFlow/watermark";
    public static final String EXPECTED_RECENT_IDS_OS = "_pollingSource_myFlow/recently-processed-ids";
    public static final String EXPECTED_IDS_UPDATED_WATERMARK_OS = "_pollingSource_myFlow/ids-on-updated-watermark";

    @Test
    public void watermarkObjectStoreNameIsBackwardsCompatible() {
        String watermarkOs = String.format("_pollingSource_%s/%s", TEST_FLOW_NAME, "watermark");
        MatcherAssert.assertThat((Object)watermarkOs, (Matcher)Matchers.is((Object)EXPECTED_WATERMARK_OS));
    }

    @Test
    public void recentlyProcessedIdsObjectStoreNameIsBackwardsCompatible() {
        String watermarkOs = String.format("_pollingSource_%s/%s", TEST_FLOW_NAME, "recently-processed-ids");
        MatcherAssert.assertThat((Object)watermarkOs, (Matcher)Matchers.is((Object)EXPECTED_RECENT_IDS_OS));
    }

    @Test
    public void idsUpdatedWatermarkObjectStoreNameIsBackwardsCompatible() {
        String watermarkOs = String.format("_pollingSource_%s/%s", TEST_FLOW_NAME, "ids-on-updated-watermark");
        MatcherAssert.assertThat((Object)watermarkOs, (Matcher)Matchers.is((Object)EXPECTED_IDS_UPDATED_WATERMARK_OS));
    }
}

