/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.error;

import static org.mule.metadata.api.builder.BaseTypeBuilder.create;
import static org.mule.runtime.extension.api.error.MuleErrors.ANY;
import static org.mule.runtime.extension.api.error.MuleErrors.CLIENT_SECURITY;
import static org.mule.runtime.extension.api.error.MuleErrors.CONNECTIVITY;
import static org.mule.runtime.extension.api.error.MuleErrors.EXPRESSION;
import static org.mule.runtime.extension.api.error.MuleErrors.REDELIVERY_EXHAUSTED;
import static org.mule.runtime.extension.api.error.MuleErrors.RETRY_EXHAUSTED;
import static org.mule.runtime.extension.api.error.MuleErrors.ROUTING;
import static org.mule.runtime.extension.api.error.MuleErrors.SECURITY;
import static org.mule.runtime.extension.api.error.MuleErrors.SERVER_SECURITY;
import static org.mule.runtime.extension.api.error.MuleErrors.TRANSFORMATION;

import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

/**
 * Provides useful static values fir use in extensions declarers dealing with error types.
 *
 * @since 1.4
 */
public final class ErrorConstants {

  private ErrorConstants() {
    // Nothing to do
  }

  private static final String ERROR_TYPE_MATCHER_ID = "errorTypeMatcher";
  private static final String ERROR_TYPE_DEFINITION_ID = "errorTypeDefinition";

  private static final MetadataFormat TEXT_PLAIN_FORMAT = new MetadataFormat("Text", "text", "text/plain");

  /**
   * Parameters of this type declare new error types specific to the artifact that declares in.
   */
  public static final MetadataType ERROR_TYPE_DEFINITION = create(TEXT_PLAIN_FORMAT)
      .stringType()
      .id(ERROR_TYPE_DEFINITION_ID)
      .build();

  /**
   * Parameters of this type declare a matcher for error types that can be generated by the application.
   */
  public static final MetadataType ERROR_TYPE_MATCHER = create(TEXT_PLAIN_FORMAT)
      .stringType()
      .id(ERROR_TYPE_MATCHER_ID)
      .enumOf(ANY.name(),
              REDELIVERY_EXHAUSTED.name(),
              TRANSFORMATION.name(),
              EXPRESSION.name(),
              SECURITY.name(),
              CLIENT_SECURITY.name(),
              SERVER_SECURITY.name(),
              ROUTING.name(),
              CONNECTIVITY.name(),
              RETRY_EXHAUSTED.name(),
              "TIMEOUT")
      .build();

}
