/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.BackPressureStrategyModelProperty;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.internal.loader.enricher.BackPressureDeclarationEnricher;

public class BackPressureDeclarationEnricherTestCase {
    private BackPressureDeclarationEnricher backPressureDeclarationEnricher;
    private ExtensionLoadingContext extensionLoadingContext;
    private ExtensionDeclaration extensionDeclaration;
    private SourceDeclaration sourceDeclaration;
    private ParameterGroupDeclaration parameterGroupDeclaration;

    @Before
    public void before() {
        this.backPressureDeclarationEnricher = new BackPressureDeclarationEnricher();
        this.extensionLoadingContext = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        this.extensionDeclaration = (ExtensionDeclaration)Mockito.mock(ExtensionDeclaration.class);
        this.sourceDeclaration = (SourceDeclaration)Mockito.mock(SourceDeclaration.class);
        ExtensionDeclarer extensionDeclarer = (ExtensionDeclarer)Mockito.mock(ExtensionDeclarer.class);
        Mockito.when((Object)extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)extensionDeclarer);
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Arrays.asList(this.sourceDeclaration));
        this.parameterGroupDeclaration = new ParameterGroupDeclaration("General");
        Mockito.when((Object)this.sourceDeclaration.getParameterGroup("General")).thenReturn((Object)this.parameterGroupDeclaration);
    }

    @Test
    public void modelPropertyIsNotPresent() {
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(BackPressureStrategyModelProperty.class)).thenReturn(Optional.empty());
        this.backPressureDeclarationEnricher.enrich(this.extensionLoadingContext);
        MatcherAssert.assertThat((Object)this.parameterGroupDeclaration.getParameters(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void enricherAddsParameter() {
        BackPressureStrategyModelProperty modelProperty = new BackPressureStrategyModelProperty(BackPressureMode.DROP, new LinkedHashSet<BackPressureMode>(Arrays.asList(BackPressureMode.DROP, BackPressureMode.WAIT)));
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(BackPressureStrategyModelProperty.class)).thenReturn(Optional.of(modelProperty));
        this.backPressureDeclarationEnricher.enrich(this.extensionLoadingContext);
        MatcherAssert.assertThat((Object)this.parameterGroupDeclaration.getParameters(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)this.parameterGroupDeclaration.getParameters().get(0);
        MatcherAssert.assertThat((Object)parameterDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"onCapacityOverload"));
        MatcherAssert.assertThat((Object)parameterDeclaration.getDefaultValue(), (Matcher)CoreMatchers.is((Object)BackPressureMode.DROP));
    }

    @Test
    public void enricherDoesNotAddParameter() {
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(BackPressureStrategyModelProperty.class)).thenReturn(Optional.of(BackPressureStrategyModelProperty.getDefault()));
        this.backPressureDeclarationEnricher.enrich(this.extensionLoadingContext);
        MatcherAssert.assertThat((Object)this.parameterGroupDeclaration.getParameters(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }
}

