/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.property.TargetModelProperty;

public final class TargetParameterDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final Map<String, Set<String>> BLOCK_LIST;

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        String extensionName = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName();
        return Optional.of(new WalkDelegateDelegateDeclaration(BLOCK_LIST.getOrDefault(extensionName, Collections.emptySet())));
    }

    static {
        SmallMap block = new SmallMap();
        block.put("ee", Collections.singleton("transform"));
        block.put("cxf", Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("simpleService", "jaxwsService", "proxyService", "simpleClient", "jaxwsClient", "proxyClient"))));
        BLOCK_LIST = Collections.unmodifiableMap(block);
    }

    private class WalkDelegateDelegateDeclaration
    extends IdempotentDeclarationEnricherWalkDelegate {
        private final Set<String> blockedOperationsNames;
        private MetadataType attributeType;
        private MetadataType targetValue;

        private WalkDelegateDelegateDeclaration(Set<String> blockedOperationsNames) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            this.attributeType = typeLoader.load(String.class);
            this.targetValue = typeLoader.load(String.class);
            this.blockedOperationsNames = blockedOperationsNames;
        }

        @Override
        protected void onOperation(OperationDeclaration declaration) {
            if (this.blockedOperationsNames.contains(declaration.getName())) {
                return;
            }
            MetadataType outputType = declaration.getOutput().getType();
            if (outputType == null) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not specify an output type", declaration.getName()));
            }
            if (!(outputType instanceof VoidType)) {
                declaration.getParameterGroup("Output").addParameter(this.declareTarget()).addParameter(this.declareTargetValue());
            }
        }

        private ParameterDeclaration declareTarget() {
            ParameterDeclaration parameter = new ParameterDeclaration("target");
            parameter.setDescription("The name of a variable on which the operation's output will be placed");
            parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
            parameter.setRequired(false);
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(this.attributeType, false);
            parameter.setDisplayModel(DisplayModel.builder().displayName("Target Variable").build());
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            return parameter;
        }

        private ParameterDeclaration declareTargetValue() {
            ParameterDeclaration parameter = new ParameterDeclaration("targetValue");
            parameter.setDescription("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable");
            parameter.setExpressionSupport(ExpressionSupport.REQUIRED);
            parameter.setRequired(false);
            parameter.setDefaultValue((Object)"#[payload]");
            parameter.setParameterRole(ParameterRole.BEHAVIOUR);
            parameter.setType(this.targetValue, false);
            parameter.setDisplayModel(DisplayModel.builder().displayName("Target Value").build());
            parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
            parameter.addModelProperty((ModelProperty)new TargetModelProperty());
            return parameter;
        }
    }
}

