/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.validator.ConnectionProviderModelValidator;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionProviderModelValidatorTestCase {
    public static final String EXTENSION_NAME = "extension";
    public static final String OPERATION_NAME = "operation";
    public static final String CONNECTION_PROVIDER_NAME = "connectionProviderName";
    public static final String PARAMETER_NAME = "parameterName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ConfigurationModel configurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ConnectionProviderModel connectionProviderModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel parameterModel;
    private ExtensionModelValidator validator = new ConnectionProviderModelValidator();
    private ProblemsReporter problemsReporter;

    @Before
    public void before() {
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)this.parameterModel.isOverrideFromConfig()).thenReturn((Object)false);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(this.configurationModel));
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderModel));
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
    }

    @Test
    public void validConnectionProvider() {
        this.validate();
    }

    @Test
    public void connectionProviderWithConfigOverrideParameter() {
        Mockito.when((Object)this.parameterModel.isOverrideFromConfig()).thenReturn((Object)true);
        this.validateError("Connection 'connectionProviderName' declares the parameters [parameterName] as '" + ConfigOverride.class.getSimpleName() + "', which is not allowed for this component parameters");
    }

    private void validate() {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void validateError(String errorMessage) {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.hasErrors(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Problem)this.problemsReporter.getErrors().get(0)).getMessage(), (Matcher)Matchers.containsString((String)errorMessage));
    }
}

