/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import io.qameta.allure.Issue;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;

public class BooleanParameterDeclarationEnricherTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Mock
    private ExtensionDeclarer declarer;
    @Mock
    private ExtensionDeclaration declaration;
    @Mock
    private ExtensionLoadingContext context;
    @Mock
    private OperationDeclaration operation;
    private ParameterDeclaration parameter;
    private final BooleanParameterDeclarationEnricher enricher = new BooleanParameterDeclarationEnricher();

    @Before
    public void setUp() {
        Mockito.when((Object)this.context.getExtensionDeclarer()).thenReturn((Object)this.declarer);
        Mockito.when((Object)this.declarer.getDeclaration()).thenReturn((Object)this.declaration);
        Mockito.when((Object)this.declaration.getOperations()).thenReturn(Arrays.asList(this.operation));
        this.parameter = new ParameterDeclaration("bool");
        this.parameter.setRequired(true);
        this.parameter.setType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).booleanType().build(), false);
        this.parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
        ParameterGroupDeclaration group = (ParameterGroupDeclaration)Mockito.mock(ParameterGroupDeclaration.class);
        Mockito.when((Object)group.getParameters()).thenReturn(Arrays.asList(this.parameter));
        Mockito.when((Object)this.operation.getParameterGroups()).thenReturn(Arrays.asList(group));
    }

    @Test
    public void booleanBecomesOptional() {
        this.enricher.enrich(this.context);
        Assert.assertThat((Object)this.parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)"false"));
    }

    @Test
    public void expressionBooleanRemainsUntouched() {
        this.parameter.setExpressionSupport(ExpressionSupport.REQUIRED);
        this.enricher.enrich(this.context);
        Assert.assertThat((Object)this.parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void configOverride() {
        this.parameter.setConfigOverride(true);
        this.enricher.enrich(this.context);
        Assert.assertThat((Object)this.parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void honourExistingDefaultValue() {
        this.parameter.setRequired(false);
        this.parameter.setDefaultValue((Object)"true");
        this.enricher.enrich(this.context);
        Assert.assertThat((Object)this.parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.parameter.getDefaultValue(), (Matcher)CoreMatchers.equalTo((Object)"true"));
    }

    @Test
    @Issue(value="W-12003688")
    public void dontSetDefaultValueToBooleanParams() {
        Mockito.when((Object)this.context.getParameter("EXTENSION_LOADER_DONT_SET_DEFAULT_VALUE_TO_BOOLEAN_PARAMS")).thenReturn(Optional.of(true));
        this.enricher.enrich(this.context);
        Assert.assertThat((Object)this.parameter.isRequired(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

