/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.extension.internal.property.NoReconnectionStrategyModelProperty;

public final class ReconnectionStrategyDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        if (!declaration.getModelProperty(NoReconnectionStrategyModelProperty.class).isPresent()) {
            return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

                @Override
                protected void onSource(SourceDeclaration declaration) {
                    this.addReconnectionIfRequired((ExecutableComponentDeclaration)declaration);
                }

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    this.addReconnectionIfRequired((ExecutableComponentDeclaration)declaration);
                }

                private void addReconnectionIfRequired(ExecutableComponentDeclaration declaration) {
                    if (declaration.isRequiresConnection()) {
                        InfrastructureParameterBuilder.addReconnectionStrategyParameter((ParameterizedDeclaration)declaration);
                    }
                }
            });
        }
        return Optional.empty();
    }
}

