/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.extension.api.runtime.exception;

import org.mule.sdk.api.runtime.exception.ExceptionHandler;

/**
 * Creates an instance of an {@link ExceptionHandler}
 *
 * @since 1.5.0
 */
public interface SdkExceptionHandlerFactory {

  /**
   * Creates a new instance of a {@link ExceptionHandler}
   *
   * @return a new {@link ExceptionHandler}
   */
  ExceptionHandler createHandler();
}
