/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.declaration.fluent.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;

@RunWith(value=MockitoJUnitRunner.class)
public class DeclarationWalkerTestCase {
    @Mock
    private ExtensionDeclaration extension;
    @Mock
    private ConfigurationDeclaration configuration;
    @Mock
    private OperationDeclaration operation;
    @Mock
    private ConstructDeclaration construct;
    @Mock
    private ConnectionProviderDeclaration connectionProvider;
    @Mock
    private ParameterGroupDeclaration parameterGroup;
    @Mock
    private ParameterDeclaration parameter;
    @Mock
    private SourceDeclaration source;
    @Mock
    private SourceCallbackDeclaration sourceCallback;

    @Before
    public void before() {
        Mockito.when((Object)this.source.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallback));
        Mockito.when((Object)this.source.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.extension.getConfigurations()).thenReturn(Arrays.asList(this.configuration));
        Mockito.when((Object)this.extension.getConstructs()).thenReturn(Arrays.asList(this.construct));
        Mockito.when((Object)this.extension.getOperations()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.extension.getMessageSources()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.extension.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.configuration.getOperations()).thenReturn(Arrays.asList(this.operation));
        Mockito.when((Object)this.configuration.getMessageSources()).thenReturn(Arrays.asList(this.source));
        Mockito.when((Object)this.configuration.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProvider));
        Mockito.when((Object)this.parameterGroup.getParameters()).thenReturn(Arrays.asList(this.parameter));
        this.addParameter(new ParameterizedDeclaration[]{this.configuration, this.operation, this.construct, this.connectionProvider, this.source, this.sourceCallback});
    }

    private void addParameter(ParameterizedDeclaration ... declarations) {
        for (ParameterizedDeclaration declaration : declarations) {
            Mockito.when((Object)declaration.getParameterGroups()).thenReturn(Arrays.asList(this.parameterGroup));
        }
    }

    @Test
    public void walk() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger constructs = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                constructs.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 2);
        this.assertCount(constructs, 1);
        this.assertCount(sources, 2);
        this.assertCount(providers, 2);
        this.assertCount(parameterGroups, 10);
        this.assertCount(parameters, 10);
    }

    @Test
    public void stopOnConfig() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
                this.stop();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 0);
        this.assertCount(parameterGroups, 0);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnOperation() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
                this.stop();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 1);
        this.assertCount(sources, 1);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 4);
        this.assertCount(parameters, 4);
    }

    @Test
    public void stopOnProvider() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
                this.stop();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 0);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnSource() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
                this.stop();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 1);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 2);
        this.assertCount(parameters, 2);
    }

    @Test
    public void stopOnGroup() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
                this.stop();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 1);
        this.assertCount(parameters, 0);
    }

    @Test
    public void stopOnParameter() {
        final AtomicInteger configs = new AtomicInteger(0);
        final AtomicInteger operations = new AtomicInteger(0);
        final AtomicInteger sources = new AtomicInteger(0);
        final AtomicInteger parameterGroups = new AtomicInteger(0);
        final AtomicInteger parameters = new AtomicInteger(0);
        final AtomicInteger providers = new AtomicInteger(0);
        new DeclarationWalker(){

            public void onConfiguration(ConfigurationDeclaration declaration) {
                configs.incrementAndGet();
            }

            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                operations.incrementAndGet();
            }

            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                providers.incrementAndGet();
            }

            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                sources.incrementAndGet();
            }

            public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
                parameterGroups.incrementAndGet();
            }

            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                Assert.assertThat((Object)parameterGroup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)DeclarationWalkerTestCase.this.parameterGroup)));
                parameters.incrementAndGet();
                this.stop();
            }
        }.walk(this.extension);
        this.assertCount(configs, 1);
        this.assertCount(operations, 0);
        this.assertCount(sources, 0);
        this.assertCount(providers, 1);
        this.assertCount(parameterGroups, 1);
        this.assertCount(parameters, 1);
    }

    private void assertCount(AtomicInteger actual, int expected) {
        Assert.assertThat((Object)actual.get(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

