/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.util;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextKeyStoreConfiguration;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.internal.loader.util.InfrastructureTypeMapping;

public class InfrastructureTypeMappingTestCase {
    @Test
    public void tlsContextFactoryIsMapped() {
        InfrastructureTypeMapping.InfrastructureType tlsInfraType = (InfrastructureTypeMapping.InfrastructureType)InfrastructureTypeMapping.getMap().get(TlsContextFactory.class);
        MatcherAssert.assertThat((Object)tlsInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)tlsInfraType.getName(), (Matcher)CoreMatchers.is((Object)"tlsContext"));
        MatcherAssert.assertThat((Object)tlsInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)8));
    }

    @Test
    public void tlsKeyStoreConfigurationIsMapped() {
        InfrastructureTypeMapping.InfrastructureType keyStoreInfraType = (InfrastructureTypeMapping.InfrastructureType)InfrastructureTypeMapping.getMap().get(TlsContextKeyStoreConfiguration.class);
        MatcherAssert.assertThat((Object)keyStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)keyStoreInfraType.getName(), (Matcher)CoreMatchers.is((Object)"KeyStore"));
        MatcherAssert.assertThat((Object)keyStoreInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)12));
    }

    @Test
    public void tlsTrustStoreConfigurationIsMapped() {
        InfrastructureTypeMapping.InfrastructureType trustStoreInfraType = (InfrastructureTypeMapping.InfrastructureType)InfrastructureTypeMapping.getMap().get(TlsContextTrustStoreConfiguration.class);
        MatcherAssert.assertThat((Object)trustStoreInfraType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)trustStoreInfraType.getName(), (Matcher)CoreMatchers.is((Object)"TrustStore"));
        MatcherAssert.assertThat((Object)trustStoreInfraType.getSequence(), (Matcher)CoreMatchers.is((Object)13));
    }

    @Test
    public void tlsKeyStoreQNameIsConfigured() {
        Optional qName = InfrastructureTypeMapping.getQName((String)"KeyStore");
        MatcherAssert.assertThat((Object)qName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"key-store"));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/tls"));
    }

    @Test
    public void tlsTrustStoreQNameIsConfigured() {
        Optional qName = InfrastructureTypeMapping.getQName((String)"TrustStore");
        MatcherAssert.assertThat((Object)qName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"trust-store"));
        MatcherAssert.assertThat((Object)((QNameModelProperty)qName.get()).getValue().getNamespaceURI(), (Matcher)CoreMatchers.is((Object)"http://www.mulesoft.org/schema/mule/tls"));
    }

    @Test
    public void tlsKeyStoreDslConfigurationIsConfigured() {
        Optional dslConfig = InfrastructureTypeMapping.getDslConfiguration((String)"KeyStore");
        MatcherAssert.assertThat((Object)dslConfig.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsInlineDefinition(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowTopLevelDefinition(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsReferences(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void tlsTrustStoreDslConfigurationIsConfigured() {
        Optional dslConfig = InfrastructureTypeMapping.getDslConfiguration((String)"TrustStore");
        MatcherAssert.assertThat((Object)dslConfig.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsInlineDefinition(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowTopLevelDefinition(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((ParameterDslConfiguration)dslConfig.get()).allowsReferences(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void streamingStrategyMappingsAreConfigured() {
        Optional fileStoreQName = InfrastructureTypeMapping.getQName((String)"repeatable-file-store-stream");
        MatcherAssert.assertThat((Object)fileStoreQName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)fileStoreQName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"repeatable-file-store-stream"));
        Optional inMemoryQName = InfrastructureTypeMapping.getQName((String)"repeatable-in-memory-stream");
        MatcherAssert.assertThat((Object)inMemoryQName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)inMemoryQName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"repeatable-in-memory-stream"));
        Optional nonRepeatableQName = InfrastructureTypeMapping.getQName((String)"non-repeatable-stream");
        MatcherAssert.assertThat((Object)nonRepeatableQName.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((QNameModelProperty)nonRepeatableQName.get()).getValue().getLocalPart(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
    }
}

