/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.util.NameUtils;

public class NameUtilsTestCase {
    private static final String TYPE_ALIAS = "Batman";
    private static final String OTHER_CLASS_NAME = "other-aliased-class";
    public static final String CLASS_NAME = "aliased-class";
    private ObjectType objectType;

    @Before
    public void setup() {
        this.objectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)this.objectType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.objectType.getAnnotation(ClassInformationAnnotation.class)).thenReturn(Optional.empty());
        ((ObjectType)Mockito.doAnswer(invocation -> {
            MetadataTypeVisitor visitor = (MetadataTypeVisitor)invocation.getArguments()[0];
            visitor.visitObject(this.objectType);
            return null;
        }).when((Object)this.objectType)).accept((MetadataTypeVisitor)Mockito.any(MetadataTypeVisitor.class));
    }

    @Test
    public void getTopLevelTypeNameByTypeAlias() {
        Mockito.when((Object)this.objectType.getAnnotation(TypeAliasAnnotation.class)).thenReturn(Optional.of(new TypeAliasAnnotation(TYPE_ALIAS)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)TYPE_ALIAS)));
    }

    @Test
    public void getTopLevelTypeNameByTypeId() {
        String typeId = this.getClass().getName();
        Mockito.when((Object)this.objectType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JSON);
        Mockito.when((Object)this.objectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(typeId)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)typeId)));
    }

    @Test
    public void getTopLevelTypeNameByClassInformationAnnotaion() {
        Mockito.when((Object)this.objectType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)this.objectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.objectType.getAnnotation(ClassInformationAnnotation.class)).thenReturn(Optional.of(new ClassInformationAnnotation(AliasedClass.class)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)CLASS_NAME)));
    }

    @Test
    public void getTopLevelTypeNameByClassInformationWithNestedInnerClass() {
        Mockito.when((Object)this.objectType.getMetadataFormat()).thenReturn((Object)MetadataFormat.JAVA);
        Mockito.when((Object)this.objectType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.objectType.getAnnotation(ClassInformationAnnotation.class)).thenReturn(Optional.of(new ClassInformationAnnotation(OtherClass.OtherAliasedClass.class)));
        Assert.assertThat((Object)NameUtils.getTopLevelTypeName((MetadataType)this.objectType), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)OTHER_CLASS_NAME)));
    }

    @Test
    public void hyphenization() {
        Assert.assertThat((Object)"my-parameter-name", (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"My Parameter Name")));
        Assert.assertThat((Object)"my-parameter-name", (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"MyParameterName")));
        Assert.assertThat((Object)"parameter-dsl", (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"ParameterDSL")));
        Assert.assertThat((Object)"parameter-dsl-name", (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)"ParameterDSLName")));
    }

    @Alias(value="Batman")
    private static class AliasedClass {
        private AliasedClass() {
        }
    }

    private static class OtherClass {
        private OtherClass() {
        }

        private static class OtherAliasedClass {
            private OtherAliasedClass() {
            }
        }
    }
}

