/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader.enricher;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.SourceClusterSupportModelProperty;
import org.mule.runtime.extension.internal.loader.enricher.ClusterSupportEnricher;
import org.mule.sdk.api.annotation.source.SourceClusterSupport;

@RunWith(value=MockitoJUnitRunner.class)
public class ClusterSupportEnricherTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SourceDeclaration sourceDeclaration;
    @Mock
    private ParameterGroupDeclaration parameterGroup;
    private ClusterSupportEnricher enricher = new ClusterSupportEnricher();
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getMessageSources()).thenReturn(Arrays.asList(this.sourceDeclaration));
        Mockito.when((Object)this.sourceDeclaration.getParameterGroup("General")).thenReturn((Object)this.parameterGroup);
        Mockito.when((Object)this.sourceDeclaration.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceDeclaration.getErrorCallback()).thenReturn(Optional.empty());
    }

    @Test
    public void clusterNotSupported() {
        this.setSourceClusterSupportModelProperty(SourceClusterSupport.NOT_SUPPORTED);
        this.assertEnrichment(false, false);
    }

    @Test
    public void defaultAllNodes() {
        this.setSourceClusterSupportModelProperty(SourceClusterSupport.DEFAULT_ALL_NODES);
        this.assertEnrichment(true, false);
    }

    @Test
    public void defaultPrimaryNodeOnly() {
        this.setSourceClusterSupportModelProperty(SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY);
        this.assertEnrichment(true, true);
    }

    @Test
    public void noPropertyFound() {
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(SourceClusterSupportModelProperty.class)).thenReturn(Optional.empty());
        this.assertEnrichment(false, false);
    }

    private void setSourceClusterSupportModelProperty(SourceClusterSupport sourceClusterSupport) {
        Mockito.when((Object)this.sourceDeclaration.getModelProperty(SourceClusterSupportModelProperty.class)).thenReturn(Optional.of(new SourceClusterSupportModelProperty(sourceClusterSupport)));
    }

    private void assertEnrichment(boolean parameterAdded, boolean defaultParameterValue) {
        this.enricher.enrich(this.extensionLoadingContext);
        if (parameterAdded) {
            ArgumentCaptor captor = ArgumentCaptor.forClass(ParameterDeclaration.class);
            ((ParameterGroupDeclaration)Mockito.verify((Object)this.parameterGroup)).addParameter((ParameterDeclaration)captor.capture());
            ParameterDeclaration parameter = (ParameterDeclaration)captor.getValue();
            Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.equalTo((Object)"primaryNodeOnly"));
            Assert.assertThat((Object)parameter.getDefaultValue(), (Matcher)CoreMatchers.is((Object)defaultParameterValue));
        } else {
            ((ParameterGroupDeclaration)Mockito.verify((Object)this.parameterGroup, (VerificationMode)Mockito.never())).addParameter((ParameterDeclaration)ArgumentMatchers.any());
        }
    }
}

