/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.test.internal.loader;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.internal.loader.enricher.ClassLoaderDeclarationEnricher;

@RunWith(value=MockitoJUnitRunner.class)
public class ClassLoaderDeclarationEnricherTestCase {
    @Mock
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    @Mock
    private ClassLoader classLoader;
    private ClassLoaderDeclarationEnricher enricher = new ClassLoaderDeclarationEnricher();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)((ExtensionDeclaration)this.extensionDeclarer.getDeclaration())).thenReturn((Object)this.extensionDeclaration);
    }

    @Test
    public void enrich() {
        this.setClassLoaderParameter(this.classLoader);
        this.enricher.enrich(this.extensionLoadingContext);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ClassLoaderModelProperty.class);
        ((ExtensionDeclarer)Mockito.verify((Object)this.extensionDeclarer)).withModelProperty((ModelProperty)captor.capture());
        ClassLoaderModelProperty property = (ClassLoaderModelProperty)captor.getValue();
        Assert.assertThat((Object)property, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)property.getClassLoader(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.classLoader)));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void noClassLoaderForEnrichment() {
        this.setClassLoaderParameter(null);
        this.enricher.enrich(this.extensionLoadingContext);
    }

    private void setClassLoaderParameter(ClassLoader classLoader) {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionClassLoader()).thenReturn((Object)classLoader);
    }
}

